/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.data;

import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateImageReference;
import ch.systemsx.sybit.imageviewer.processors.ImageUtil;
import ij.ImagePlus;
import java.awt.image.ColorModel;

public class ImageHandler {
    private ImagePlus image;
    private PlateImageReference imageReference;
    private ColorModel originalColorModel;
    private ImagePlus originalImage;
    private ImageHandler fullSizeImage;
    private String path;

    public ImageHandler(ImagePlus image, PlateImageReference plateImageReference) {
        this.image = image;
        this.imageReference = plateImageReference;
        if (image.getType() != 4) {
            this.originalColorModel = image.getProcessor().getColorModel();
        } else {
            this.originalImage = ImageUtil.generateImageCopy(image);
        }
    }

    public ImagePlus getImage() {
        return this.image;
    }

    public void setImage(ImagePlus image) {
        this.image = image;
    }

    public PlateImageReference getImageReference() {
        return this.imageReference;
    }

    public void setImageReference(PlateImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public ColorModel getOriginalColorModel() {
        return this.originalColorModel;
    }

    public void setOriginalColorModel(ColorModel originalColorModel) {
        this.originalColorModel = originalColorModel;
    }

    public void setFullSizeImage(ImageHandler fullSizeImage) {
        this.fullSizeImage = fullSizeImage;
    }

    public ImageHandler getFullSizeImage() {
        return this.fullSizeImage;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ImagePlus getOriginalImage() {
        return this.originalImage;
    }

    public void setOriginalImage(ImagePlus originalImage) {
        this.originalImage = originalImage;
    }
}

