/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.BitSetConversionUtils;
import ch.systemsx.cisd.hdf5.HDF5BaseWriter;
import ch.systemsx.cisd.hdf5.HDF5BooleanReader;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5BooleanWriter;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5D;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.util.BitSet;

public class HDF5BooleanWriter
extends HDF5BooleanReader
implements IHDF5BooleanWriter {
    private final HDF5BaseWriter baseWriter;

    HDF5BooleanWriter(HDF5BaseWriter baseWriter) {
        super(baseWriter);
        assert (baseWriter != null);
        this.baseWriter = baseWriter;
    }

    @Override
    public void setAttr(String objectPath, String name, boolean value) {
        this.baseWriter.checkOpen();
        this.baseWriter.setAttribute(objectPath, name, this.baseWriter.booleanDataTypeId, this.baseWriter.booleanDataTypeId, new byte[]{(byte)(value ? 1 : 0)});
    }

    @Override
    public void write(String objectPath, boolean value) {
        this.baseWriter.checkOpen();
        this.baseWriter.writeScalar(objectPath, this.baseWriter.booleanDataTypeId, this.baseWriter.booleanDataTypeId, HDFNativeData.byteToByte((byte)(value ? 1 : 0)));
    }

    @Override
    public void writeBitField(String objectPath, BitSet data) {
        this.writeBitField(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeBitField(final String objectPath, final BitSet data, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int msb = data.length();
                int realLength = msb / 64 + (msb % 64 != 0 ? 1 : 0);
                int dataSetId = HDF5BooleanWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_B64LE, new long[]{realLength}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void createBitField(String objectPath, int size) {
        this.createBitField(objectPath, size, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createBitField(String objectPath, long size, int blockSize) {
        this.createBitField(objectPath, size, blockSize, HDF5IntStorageFeatures.INT_NO_COMPRESSION);
    }

    @Override
    public void createBitField(final String objectPath, final int size, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                if (features.requiresChunking()) {
                    HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[1], new long[]{size}, 8, registry);
                } else {
                    HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[]{size}, null, 8, registry);
                }
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void createBitField(final String objectPath, final long size, final int blockSize, final HDF5IntStorageFeatures features) {
        assert (objectPath != null);
        assert (size >= 0L);
        assert (blockSize >= 0 && ((long)blockSize <= size || size == 0L));
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> createRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                HDF5BooleanWriter.this.baseWriter.createDataSet(objectPath, HDF5Constants.H5T_STD_B64LE, features, new long[]{size}, new long[]{blockSize}, 8, registry);
                return null;
            }
        };
        this.baseWriter.runner.call(createRunnable);
    }

    @Override
    public void writeBitFieldBlock(String objectPath, BitSet data, int dataSize, long blockNumber) {
        this.writeBitFieldBlockWithOffset(objectPath, data, dataSize, (long)dataSize * blockNumber);
    }

    @Override
    public void writeBitFieldBlockWithOffset(final String objectPath, final BitSet data, final int dataSize, final long offset) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                long[] blockDimensions = new long[]{dataSize};
                long[] slabStartOrNull = new long[]{offset};
                int dataSetId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.openAndExtendDataSet(((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileId, objectPath, ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.fileFormat, new long[]{offset + (long)dataSize}, -1, registry);
                int dataSpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.getDataSpaceForDataSet(dataSetId, registry);
                ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.setHyperslabBlock(dataSpaceId, slabStartOrNull, blockDimensions);
                int memorySpaceId = ((HDF5BooleanWriter)HDF5BooleanWriter.this).baseWriter.h5.createSimpleDataSpace(blockDimensions, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, memorySpaceId, dataSpaceId, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, dataSize));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }

    @Override
    public void writeBitFieldArray(String objectPath, BitSet[] data) {
        this.writeBitFieldArray(objectPath, data, HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION);
    }

    @Override
    public void writeBitFieldArray(final String objectPath, final BitSet[] data, final HDF5GenericStorageFeatures features) {
        assert (objectPath != null);
        assert (data != null);
        this.baseWriter.checkOpen();
        ICallableWithCleanUp<Void> writeRunnable = new ICallableWithCleanUp<Void>(){

            @Override
            public Void call(ICleanUpRegistry registry) {
                int msb = BitSetConversionUtils.getMaxLengthInWords(data);
                int numberOfWords = msb / 64 + (msb % 64 != 0 ? 1 : 0);
                int dataSetId = HDF5BooleanWriter.this.baseWriter.getOrCreateDataSetId(objectPath, HDF5Constants.H5T_STD_B64LE, new long[]{numberOfWords, data.length}, 8, features, registry);
                H5D.H5Dwrite(dataSetId, HDF5Constants.H5T_NATIVE_B64, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, BitSetConversionUtils.toStorageForm(data, numberOfWords));
                return null;
            }
        };
        this.baseWriter.runner.call(writeRunnable);
    }
}

