/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.QueryTool;
import net.lemnik.eodsql.TypeMapper;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.ArrayWrapper;
import net.lemnik.eodsql.spi.util.CollectionWrapperFactory;
import net.lemnik.eodsql.spi.util.DataIteratorWrapper;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.DataSetWrapper;
import net.lemnik.eodsql.spi.util.MapDataObjectBinding;
import net.lemnik.eodsql.spi.util.SingleRowResultSetWrapper;
import net.lemnik.eodsql.spi.util.TypeMapperDataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultSetWrapper<T> {
    public static final String PARAMETER_BINDING_TYPE = "net.lemnik.eodsql.spi.util.ResultSetWrapper#bindingType";
    public static final String PARAMETER_CUSTOM_DATA_OBJECT_BINDING = "net.lemnik.eodsql.spi.util.ResultSetWrapper#binding";
    private static final Set<Factory> FACTORIES = new LinkedHashSet<Factory>(4);
    private static final Map<String, Object> NO_PARAMETERS = Collections.emptyMap();

    protected ResultSetWrapper() {
    }

    private static ResultSetWrapper getResultSetWrapperForSimpleClass(Class<?> clazz, DataObjectBinding.BindingType bindingType, DataObjectBinding dataObjectBinding) {
        if (dataObjectBinding != null) {
            dataObjectBinding.setObjectType(clazz);
            return new SingleRowResultSetWrapper(dataObjectBinding);
        }
        TypeMapper typeMapper = QueryTool.getTypeMap().get(clazz);
        if (typeMapper != null) {
            return ResultSetWrapper.getTypeMapperResultSetWrapper(typeMapper, clazz);
        }
        return ResultSetWrapper.getDataObjectResultSetWrapper(clazz, bindingType);
    }

    private static <T> ResultSetWrapper<T> getTypeMapperResultSetWrapper(TypeMapper<T> typeMapper, Class<T> clazz) {
        TypeMapperDataObjectBinding<T> typeMapperDataObjectBinding = new TypeMapperDataObjectBinding<T>(typeMapper, clazz);
        return new SingleRowResultSetWrapper<T>(typeMapperDataObjectBinding);
    }

    private static <T> ResultSetWrapper getDataObjectResultSetWrapper(Class<T> clazz, DataObjectBinding.BindingType bindingType) {
        DataObjectBinding<T> dataObjectBinding = DataObjectBinding.getDataObjectBinding(clazz, bindingType);
        return new SingleRowResultSetWrapper<T>(dataObjectBinding);
    }

    protected T wrap(ResultSet resultSet) throws SQLException {
        throw new UnsupportedOperationException();
    }

    protected static DataObjectBinding.BindingType getBindingType(Map<String, Object> map) {
        if (map.containsKey(PARAMETER_BINDING_TYPE)) {
            return (DataObjectBinding.BindingType)((Object)map.get(PARAMETER_BINDING_TYPE));
        }
        return DataObjectBinding.BindingType.NORMAL_BINDING;
    }

    protected static DataObjectBinding<?> getCustomBinding(Map<String, Object> map) {
        if (map.containsKey(PARAMETER_CUSTOM_DATA_OBJECT_BINDING)) {
            return (DataObjectBinding)map.get(PARAMETER_CUSTOM_DATA_OBJECT_BINDING);
        }
        return null;
    }

    public T wrap(Context<?> context) throws SQLException {
        return this.wrap(context.getResource(ResultSet.class).get());
    }

    public int getPreferredResultSetType() {
        return 1004;
    }

    public int getPreferredResultSetConcurrency() {
        return 1007;
    }

    public String[] getKeyColumnNames() {
        return DataObjectBinding.NO_KEY_COLUMNS;
    }

    public static void addFactory(Factory factory) {
        FACTORIES.add(factory);
    }

    public static void removeFactory(Factory factory) {
        FACTORIES.add(factory);
    }

    public static void validate(Type type) throws InvalidDataTypeException, InvalidQueryException {
        if (type instanceof Class && !((Class)type).isArray()) {
            Class clazz = (Class)type;
            if (!QueryTool.getTypeMap().containsKey(clazz)) {
                DataObjectBinding.validate(clazz);
            }
        } else {
            for (Factory factory : FACTORIES) {
                if (!factory.isTypeConstructable(type, NO_PARAMETERS)) continue;
                return;
            }
            throw new InvalidDataTypeException("Cannot find a ResultSetWrapper to handle type", type);
        }
    }

    public static ResultSetWrapper get(Type type, Map<String, Object> map) throws InvalidDataTypeException, InvalidQueryException {
        if (type instanceof Class && !((Class)type).isArray() || ResultSetWrapper.isStringObjectMap(type)) {
            Class<?> clazz = ResultSetWrapper.toClass(type);
            return ResultSetWrapper.getResultSetWrapperForSimpleClass(clazz, ResultSetWrapper.getBindingType(map), ResultSetWrapper.getCustomBinding(map));
        }
        for (Factory factory : FACTORIES) {
            if (!factory.isTypeConstructable(type, map)) continue;
            return factory.create(type, map);
        }
        throw new InvalidDataTypeException("Cannot find a ResultSetWrapper to handle type", type);
    }

    static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (ResultSetWrapper.isStringObjectMap(type)) {
            return MapDataObjectBinding.getStringObjectMapObjectType();
        }
        if (ResultSetWrapper.isStringObjectMapArray(type)) {
            return Map[].class;
        }
        throw new InvalidQueryException("Return type must be a class");
    }

    static boolean isStringObjectMap(Type type) {
        if (type instanceof ParameterizedType) {
            Type type2 = ((ParameterizedType)type).getRawType();
            if (type2 != Map.class) {
                return false;
            }
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            if (typeArray.length == 2 && typeArray[0] instanceof Class && typeArray[1] instanceof Class) {
                Class clazz = (Class)typeArray[0];
                Class clazz2 = (Class)typeArray[1];
                if (clazz == String.class && clazz2 == Object.class) {
                    return true;
                }
            }
        }
        return false;
    }

    static boolean isStringObjectMapArray(Type type) {
        GenericArrayType genericArrayType;
        return type instanceof GenericArrayType && ResultSetWrapper.isStringObjectMap((genericArrayType = (GenericArrayType)type).getGenericComponentType());
    }

    static {
        ResultSetWrapper.addFactory(new DataSetWrapper.Factory());
        ResultSetWrapper.addFactory(new DataIteratorWrapper.Factory());
        ResultSetWrapper.addFactory(new ArrayWrapper.Factory());
        ResultSetWrapper.addFactory(new CollectionWrapperFactory());
        try {
            Iterable iterable = (Iterable)Class.forName("java.util.ServiceLoader").getMethod("load", Class.class).invoke(null, Factory.class);
            for (Factory factory : iterable) {
                ResultSetWrapper.addFactory(factory);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public boolean isTypeConstructable(Type var1, Map<String, Object> var2) throws InvalidQueryException;

        public ResultSetWrapper create(Type var1, Map<String, Object> var2);
    }
}

