/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.image.IStreamingImageTransformer;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.IProcessIOHandler;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ConvertToolImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class ConvertToolImageTransformer
implements IStreamingImageTransformer {
    private static final String PNG = "png";
    private static final File imageMagickConvertUtilityOrNull = OSUtilities.findExecutable((String)"convert");
    private static final File graphicsMagickUtilityOrNull = OSUtilities.findExecutable((String)"gm");
    private static final Logger machineLog;
    private static final Logger operationLog;
    private final byte[] buffer = new byte[4096];
    private final List<String> convertCliArguments;
    private final boolean useGraphicsMagic;

    static {
        if (imageMagickConvertUtilityOrNull == null && graphicsMagickUtilityOrNull == null) {
            throw new ConfigurationFailureException("Neither ImageMagick 'convert' nor GraphisMagick 'gm' can be found on the system path. Requested image transformation is not available.");
        }
        machineLog = LogFactory.getLogger((LogCategory)LogCategory.MACHINE, ConvertToolImageTransformer.class);
        operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, ConvertToolImageTransformer.class);
    }

    protected ConvertToolImageTransformer(String arguments, ConvertToolImageTransformerFactory.ToolChoice choiceOrNull) {
        this.convertCliArguments = this.parseCommandArguments(arguments);
        ConvertToolImageTransformerFactory.ToolChoice choice = choiceOrNull == null ? ConvertToolImageTransformerFactory.ToolChoice.ENFORCE_IMAGEMAGICK : choiceOrNull;
        switch (choice) {
            case ENFORCE_IMAGEMAGICK: {
                if (imageMagickConvertUtilityOrNull == null) {
                    throw new ConfigurationFailureException("The ImageMagick 'convert' tool cannot be found on the system path. Requested image transformation is not available.");
                }
                this.useGraphicsMagic = false;
                break;
            }
            case ENFORCE_GRAPHICSMAGICK: {
                if (graphicsMagickUtilityOrNull == null) {
                    throw new ConfigurationFailureException("The GraphicsMagic 'gm' tool cannot be found on the system path. Requested image transformation is not available.");
                }
                this.useGraphicsMagic = true;
                break;
            }
            case PREFER_IMAGEMAGICK: {
                this.useGraphicsMagic = imageMagickConvertUtilityOrNull == null;
                break;
            }
            case PREFER_GRAPHICSMAGICK: {
                this.useGraphicsMagic = graphicsMagickUtilityOrNull != null;
                break;
            }
            default: {
                throw new Error("Unknown ToolChoice " + (Object)((Object)choice) + ".");
            }
        }
    }

    public BufferedImage transform(BufferedImage image) {
        try {
            byte[] input = ImageUtil.imageToPngFast((BufferedImage)image);
            byte[] output = this.transform(input);
            return this.toBufferedImage(output);
        }
        catch (IOException ioex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ioex);
        }
    }

    public BufferedImage transform(InputStream input) {
        return this.toBufferedImage(this.transformToPNG(input));
    }

    public byte[] transformToPNG(InputStream input) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transformToPNGStream(input, bos);
        return bos.toByteArray();
    }

    public void transformToPNGStream(InputStream input, OutputStream output) {
        try {
            this.transform(input, output);
        }
        catch (IOException ioex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ioex);
        }
    }

    private BufferedImage toBufferedImage(byte[] output) throws ConfigurationFailureException {
        IImageReader imageReader = ImageReaderFactory.tryGetReader((String)"ImageIO", (String)PNG);
        if (imageReader == null) {
            throw new ConfigurationFailureException("No ImageIO image readers available");
        }
        return imageReader.readImage(output, ImageID.NULL, null);
    }

    private byte[] transform(byte[] input) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.transform(bis, bos);
        return bos.toByteArray();
    }

    private void transform(InputStream input, OutputStream output) throws IOException {
        ArrayList<String> errorLines = new ArrayList<String>();
        ProcessIOStrategy customIOStrategy = this.createCustomProcessIOStrategy(input, output, errorLines);
        ProcessResult result = ProcessExecutionHelper.run(this.getCommandLine(), (Logger)operationLog, (Logger)machineLog, (long)-1L, (ProcessIOStrategy)customIOStrategy, (boolean)false);
        if (!result.isOK()) {
            String msg = String.format("Error calling '%s'. Exit value: %d, I/O status: %s\nError output: %s", this.getCommandLine().toString(), result.getExitValue(), result.getProcessIOResult().getStatus(), ((Object)errorLines).toString());
            operationLog.warn((Object)msg);
            throw new IOException(msg);
        }
    }

    private ProcessIOStrategy createCustomProcessIOStrategy(final InputStream input, final OutputStream output, final List<String> errorLines) {
        return ProcessIOStrategy.createCustom((IProcessIOHandler)new IProcessIOHandler(){

            public void handle(AtomicBoolean processRunning, OutputStream stdin, InputStream stdout, InputStream stderr) throws IOException {
                int n = 0;
                BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(stderr));
                while (processRunning.get() && -1 != (n = input.read(ConvertToolImageTransformer.this.buffer))) {
                    stdin.write(ConvertToolImageTransformer.this.buffer, 0, n);
                    ProcessExecutionHelper.readBytesIfAvailable((InputStream)stdout, (OutputStream)output, (byte[])ConvertToolImageTransformer.this.buffer, (long)-1L, (boolean)false);
                    ProcessExecutionHelper.readTextIfAvailable((BufferedReader)stdErrReader, (List)errorLines, (boolean)false);
                }
                stdin.flush();
                stdin.close();
                while (processRunning.get()) {
                    ProcessExecutionHelper.readBytesIfAvailable((InputStream)stdout, (OutputStream)output, (byte[])ConvertToolImageTransformer.this.buffer, (long)-1L, (boolean)false);
                    ProcessExecutionHelper.readTextIfAvailable((BufferedReader)stdErrReader, (List)errorLines, (boolean)false);
                }
                ProcessExecutionHelper.readBytesIfAvailable((InputStream)stdout, (OutputStream)output, (byte[])ConvertToolImageTransformer.this.buffer, (long)-1L, (boolean)false);
                ProcessExecutionHelper.readTextIfAvailable((BufferedReader)stdErrReader, (List)errorLines, (boolean)false);
            }
        });
    }

    private List<String> parseCommandArguments(String argsString) {
        String[] arguments = argsString.trim().split("\\s");
        return Arrays.asList(arguments);
    }

    private List<String> getCommandLine() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.useGraphicsMagic) {
            result.add(graphicsMagickUtilityOrNull.getPath());
            result.add("convert");
        } else {
            result.add(imageMagickConvertUtilityOrNull.getPath());
        }
        result.addAll(this.convertCliArguments);
        result.add("-");
        result.add("png:-");
        return result;
    }
}

