/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import eu.basysbio.cisd.dss.DBUtils;
import eu.basysbio.cisd.dss.DataSetHandler;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class PostRegistrationDatabaseUploadTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, PostRegistrationDatabaseUploadTask.class);
    private final IEncapsulatedOpenBISService service;
    private final File storeRoot;
    private DataSource dataSource;
    private DataSetHandler dataSetHandler;

    public PostRegistrationDatabaseUploadTask() {
        LogInitializer.init();
        this.service = ServiceProvider.getOpenBISService();
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        this.storeRoot = new File(PropertyUtils.getMandatoryProperty((Properties)properties, (String)"storeroot-dir"));
    }

    public void setUp(String pluginName, Properties properties) {
        this.dataSource = DBUtils.createDBContext(properties).getDataSource();
        Properties allProperties = Parameters.createParametersForApiUse().getProperties();
        this.dataSetHandler = new DataSetHandler((Properties)ExtendedProperties.getSubset((Properties)allProperties, (String)"main-thread.storage-processor.processor.", (boolean)true), this.dataSource, this.service);
    }

    public void execute() {
        Set<String> knownDataSets = this.getKnownDataSets();
        List dataSets = this.service.listPhysicalDataSets();
        Collections.sort(dataSets, new Comparator<SimpleDataSetInformationDTO>(){

            @Override
            public int compare(SimpleDataSetInformationDTO o1, SimpleDataSetInformationDTO o2) {
                return o1.getDataSetCode().compareTo(o2.getDataSetCode());
            }
        });
        for (SimpleDataSetInformationDTO dataSet : dataSets) {
            File share;
            File pathToDataSet;
            File[] dataSetFiles;
            if (knownDataSets.contains(dataSet.getDataSetCode()) || (dataSetFiles = new File(pathToDataSet = new File(share = new File(this.storeRoot, dataSet.getDataSetShareId()), dataSet.getDataSetLocation()), "original").listFiles()) == null || dataSetFiles.length <= 0) continue;
            File[] fileArray = dataSetFiles;
            int n = dataSetFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dataSetFile = fileArray[n2];
                this.printMemoryUsage();
                DataSetInformation dataSetInformation = this.createDataSetInformation(dataSet);
                try {
                    this.dataSetHandler.upload(dataSetFile, dataSetInformation);
                    this.dataSetHandler.commit();
                    if (operationLog.isInfoEnabled()) {
                        operationLog.info((Object)("Data set " + dataSet.getDataSetCode() + " successfully uploaded."));
                    }
                }
                catch (Exception ex) {
                    try {
                        operationLog.error((Object)("Uploading of data set " + dataSet.getDataSetCode() + " failed: "), (Throwable)ex);
                        this.dataSetHandler.rollback();
                    }
                    catch (Exception ex1) {
                        operationLog.error((Object)("Rollback of uploading data set " + dataSet.getDataSetCode() + " failed: "), (Throwable)ex1);
                    }
                }
                ++n2;
            }
        }
    }

    private void printMemoryUsage() {
        long mb = 0x100000L;
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory() / mb;
        long freeMemory = runtime.freeMemory() / mb;
        long maxMemory = runtime.maxMemory() / mb;
        operationLog.info((Object)("MEMORY: used=" + (totalMemory - freeMemory) + ", total=" + totalMemory + " max=" + maxMemory));
    }

    private DataSetInformation createDataSetInformation(SimpleDataSetInformationDTO dataSet) {
        DataSetInformation dataSetInformation = new DataSetInformation();
        String dataSetCode = dataSet.getDataSetCode();
        dataSetInformation.setDataSetCode(dataSetCode);
        DataSetType dataSetType = new DataSetType();
        dataSetType.setCode(dataSet.getDataSetType());
        dataSetInformation.setDataSetType(dataSetType);
        String groupCode = dataSet.getSpaceCode();
        dataSetInformation.setSpaceCode(groupCode);
        String databaseInstanceCode = dataSet.getDatabaseInstanceCode();
        String projectCode = dataSet.getProjectCode();
        String experimentCode = dataSet.getExperimentCode();
        dataSetInformation.setExperimentIdentifier(new ExperimentIdentifier(databaseInstanceCode, groupCode, projectCode, experimentCode));
        AbstractExternalData fullDataSet = this.service.tryGetDataSet(dataSetCode);
        List properties = fullDataSet.getProperties();
        ArrayList<NewProperty> dataSetProperties = new ArrayList<NewProperty>();
        for (IEntityProperty property : properties) {
            String name = property.getPropertyType().getCode();
            String value = property.tryGetAsString();
            dataSetProperties.add(new NewProperty(name, value));
        }
        dataSetInformation.setDataSetProperties(dataSetProperties);
        return dataSetInformation;
    }

    private Set<String> getKnownDataSets() {
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ITimeSeriesDAO dao = (ITimeSeriesDAO)QueryTool.getQuery((Connection)connection, ITimeSeriesDAO.class);
            DataSet<String> dataSet = dao.findDataSets();
            HashSet<String> dataSets = new HashSet<String>();
            dataSets.addAll((Collection<String>)dataSet);
            dataSet.close();
            HashSet<String> hashSet = dataSets;
            return hashSet;
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
    }
}

