/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.etlserver.proteomics;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.etlserver.proteomics.AbstractDataSetInfoExtractorWithService;
import ch.systemsx.cisd.openbis.etlserver.proteomics.Util;
import ch.systemsx.cisd.openbis.etlserver.proteomics.dto.ParentDataSetCodes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class DataSetInfoExtractorForProteinResults
extends AbstractDataSetInfoExtractorWithService {
    @Private
    static final String EXPERIMENT_TYPE_CODE_KEY = "experiment-type-code";
    @Private
    static final String EXPERIMENT_CODE_KEY = "experiment-code";
    @Private
    static final String EXPERIMENT_PROPERTIES_FILE_NAME_KEY = "experiment-properties-file-name";
    @Private
    static final String DEFAULT_EXPERIMENT_TYPE_CODE = "MS_SEARCH";
    @Private
    static final String SEPARATOR_KEY = "separator";
    @Private
    static final String DEFAULT_SEPARATOR = "&";
    @Private
    static final String DEFAULT_EXPERIMENT_PROPERTIES_FILE_NAME = "search.properties";
    static final String PARENT_DATA_SET_CODES = "parent-data-set-codes";
    static final String EXPERIMENT_IDENTIFIER_KEY = "base-experiment";
    private final String separator;
    private final String experimentPropertiesFileName;
    private final String experimentTypeCode;

    public DataSetInfoExtractorForProteinResults(Properties properties) {
        this(properties, ServiceProvider.getOpenBISService());
    }

    DataSetInfoExtractorForProteinResults(Properties properties, IEncapsulatedOpenBISService service) {
        super(service);
        this.separator = properties.getProperty(SEPARATOR_KEY, DEFAULT_SEPARATOR);
        this.experimentPropertiesFileName = properties.getProperty(EXPERIMENT_PROPERTIES_FILE_NAME_KEY, DEFAULT_EXPERIMENT_PROPERTIES_FILE_NAME);
        this.experimentTypeCode = properties.getProperty(EXPERIMENT_TYPE_CODE_KEY, DEFAULT_EXPERIMENT_TYPE_CODE);
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        String name = incomingDataSetPath.getName();
        String[] items = StringUtils.splitByWholeSeparator((String)name, (String)this.separator);
        if (items.length < 2) {
            throw new UserFailureException("The name of the data set should have at least two parts separated by '" + this.separator + "': " + name);
        }
        ProjectIdentifier projectIdentifier = new ProjectIdentifier(items[0], items[1]);
        Properties properties = this.loadSearchProperties(new File(incomingDataSetPath, this.experimentPropertiesFileName));
        String experimentCode = properties.getProperty(EXPERIMENT_CODE_KEY);
        if (experimentCode == null) {
            experimentCode = (String)this.service.generateCodes("E", EntityKind.EXPERIMENT, 1).get(0);
        }
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(projectIdentifier, experimentCode);
        NewExperiment experiment = new NewExperiment(experimentIdentifier.toString(), this.experimentTypeCode);
        ExperimentType experimentType = this.service.getExperimentType(this.experimentTypeCode);
        experiment.setProperties(Util.getAndCheckProperties(properties, (EntityType)experimentType));
        DataSetInformation info = new DataSetInformation();
        info.setExperimentIdentifier(experimentIdentifier);
        String parentDataSetCodesOrNull = this.getProperty(properties, PARENT_DATA_SET_CODES);
        String baseExperimentIdentifier = this.getProperty(properties, EXPERIMENT_IDENTIFIER_KEY);
        ParentDataSetCodes parentDataSetCodes = DataSetInfoExtractorForProteinResults.getParentDataSetCodes(parentDataSetCodesOrNull, baseExperimentIdentifier, this.service);
        if (parentDataSetCodes.getErrorMessage() != null) {
            throw new UserFailureException(parentDataSetCodes.getErrorMessage());
        }
        info.setParentDataSetCodes(parentDataSetCodes.getDataSetCodes());
        this.service.registerExperiment(experiment);
        return info;
    }

    static ParentDataSetCodes getParentDataSetCodes(String parentDataSetCodesOrNull, String baseExperimentIdentifier, IEncapsulatedOpenBISService service) {
        ArrayList<AbstractExternalData> parentDataSets = new ArrayList<AbstractExternalData>();
        StringBuilder builder = new StringBuilder();
        if (parentDataSetCodesOrNull != null) {
            String[] stringArray = StringUtils.split((String)parentDataSetCodesOrNull, (String)", ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                AbstractExternalData dataSet = service.tryGetDataSet(code);
                if (dataSet != null) {
                    parentDataSets.add(dataSet);
                } else {
                    builder.append(builder.length() == 0 ? "Unknown data sets: " : ", ");
                    builder.append(code);
                }
                ++n2;
            }
        } else if (baseExperimentIdentifier != null) {
            ExperimentIdentifier identifier = new ExperimentIdentifierFactory(baseExperimentIdentifier).createIdentifier();
            Experiment baseExperiment = service.tryGetExperiment(identifier);
            if (baseExperiment != null) {
                parentDataSets.addAll(service.listDataSetsByExperimentID(baseExperiment.getId().longValue()));
            } else {
                builder.append("Unkown experiment ").append(baseExperimentIdentifier);
            }
        }
        ArrayList<String> parentDataSetCodes = new ArrayList<String>();
        for (AbstractExternalData dataSet : parentDataSets) {
            parentDataSetCodes.add(dataSet.getCode());
        }
        String errorMessage = builder.length() > 0 ? builder.toString() : null;
        return new ParentDataSetCodes(parentDataSetCodes, errorMessage);
    }

    private String getProperty(Properties properties, String key) {
        String property = properties.getProperty(key);
        if (property == null) {
            property = properties.getProperty(key.toUpperCase());
        }
        return property;
    }

    private Properties loadSearchProperties(File propertiesFile) {
        Properties properties = !propertiesFile.exists() ? new Properties() : PropertyIOUtils.loadProperties((File)propertiesFile);
        return properties;
    }
}

