/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColor;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgChannelDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgContainerDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgExperimentDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageTransformationDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImagingDatabaseHelper {
    private final IImagingQueryDAO dao;

    private ImagingDatabaseHelper(IImagingQueryDAO dao) {
        this.dao = dao;
    }

    public static ImagingChannelsMap getOrCreateDatasetChannels(IImagingQueryDAO dao, long datasetId, List<Channel> channels) {
        ChannelOwner channelOwner = ChannelOwner.createDataset(datasetId);
        return new ImagingChannelsCreator(dao).getOrCreateChannelsMap(channelOwner, channels);
    }

    public static long getOrCreateExperimentAndContainer(IImagingQueryDAO dao, HCSContainerDatasetInfo info) {
        return ImagingDatabaseHelper.doGetOrCreateExperimentAndContainer(dao, info).getContainerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExperimentAndContainerIds doGetOrCreateExperimentAndContainer(IImagingQueryDAO dao, HCSContainerDatasetInfo info) {
        Class<IImagingQueryDAO> clazz = IImagingQueryDAO.class;
        synchronized (IImagingQueryDAO.class) {
            CreatedOrFetchedEntity exp = ImagingDatabaseHelper.getOrCreateExperiment(dao, info);
            CreatedOrFetchedEntity cont = ImagingDatabaseHelper.getOrCreateContainer(dao, info, exp.getId());
            if (!exp.hasAlreadyExisted() || !cont.hasAlreadyExisted()) {
                dao.commit();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return new ExperimentAndContainerIds(exp.getId(), cont.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExperimentWithChannelsAndContainer getOrCreateExperimentWithChannelsAndContainer(IImagingQueryDAO dao, HCSContainerDatasetInfo info, List<Channel> channels) {
        ImagingDatabaseHelper helper = new ImagingDatabaseHelper(dao);
        Class<IImagingQueryDAO> clazz = IImagingQueryDAO.class;
        synchronized (IImagingQueryDAO.class) {
            CreatedOrFetchedEntity exp = ImagingDatabaseHelper.getOrCreateExperiment(dao, info);
            long expId = exp.getId();
            CreatedOrFetchedEntity cont = ImagingDatabaseHelper.getOrCreateContainer(dao, info, expId);
            ImagingChannelsMap channelsMap = helper.getOrCreateChannels(ChannelOwner.createExperiment(expId), channels);
            dao.commit();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return new ExperimentWithChannelsAndContainer(expId, cont.getId(), channelsMap);
        }
    }

    private ImagingChannelsMap getOrCreateChannels(ChannelOwner channelOwner, List<Channel> channels) {
        return new ImagingChannelsCreator(this.dao).getOrCreateChannelsMap(channelOwner, channels);
    }

    private static CreatedOrFetchedEntity getOrCreateContainer(IImagingQueryDAO dao, HCSContainerDatasetInfo info, long expId) {
        String containerPermId = info.getContainerSamplePermId();
        Long containerId = dao.tryGetContainerIdPermId(containerPermId);
        if (containerId != null) {
            return new CreatedOrFetchedEntity(true, containerId);
        }
        ImgContainerDTO container = new ImgContainerDTO(containerPermId, info.getContainerRows(), info.getContainerColumns(), expId);
        containerId = dao.addContainer(container);
        return new CreatedOrFetchedEntity(false, containerId);
    }

    private static CreatedOrFetchedEntity getOrCreateExperiment(IImagingQueryDAO dao, HCSContainerDatasetInfo info) {
        String experimentPermId = info.getExperimentPermId();
        ImgExperimentDTO experiment = dao.tryGetExperimentByPermId(experimentPermId);
        if (experiment != null) {
            return new CreatedOrFetchedEntity(true, experiment.getId());
        }
        Long expId = dao.addExperiment(experimentPermId);
        return new CreatedOrFetchedEntity(false, expId);
    }

    private static class ChannelOwner {
        private final Long expIdOrNull;
        private final Long datasetIdOrNull;

        public static ChannelOwner createDataset(long datasetId) {
            return new ChannelOwner(null, datasetId);
        }

        public static ChannelOwner createExperiment(long expId) {
            return new ChannelOwner(expId, null);
        }

        private ChannelOwner(Long expIdOrNull, Long datasetIdOrNull) {
            this.expIdOrNull = expIdOrNull;
            this.datasetIdOrNull = datasetIdOrNull;
        }

        public Long tryGetExperimentId() {
            return this.expIdOrNull;
        }

        public Long tryGetDatasetId() {
            return this.datasetIdOrNull;
        }
    }

    private static class CreatedOrFetchedEntity {
        private final boolean alreadyExisted;
        private final long id;

        public CreatedOrFetchedEntity(boolean alreadyExisted, long id) {
            this.alreadyExisted = alreadyExisted;
            this.id = id;
        }

        public boolean hasAlreadyExisted() {
            return this.alreadyExisted;
        }

        public long getId() {
            return this.id;
        }
    }

    private static class ExperimentAndContainerIds {
        private final long experimentId;
        private final long containerId;

        public ExperimentAndContainerIds(long experimentId, long containerId) {
            this.experimentId = experimentId;
            this.containerId = containerId;
        }

        public long getExperimentId() {
            return this.experimentId;
        }

        public long getContainerId() {
            return this.containerId;
        }
    }

    public static class ExperimentWithChannelsAndContainer
    extends ExperimentAndContainerIds {
        private final ImagingChannelsMap channelsMap;

        public ExperimentWithChannelsAndContainer(long experimentId, long containerId, ImagingChannelsMap channelsMap) {
            super(experimentId, containerId);
            this.channelsMap = channelsMap;
        }

        public ImagingChannelsMap getChannelsMap() {
            return this.channelsMap;
        }
    }

    @Private
    static class ImagingChannelsCreator {
        private final IImagingQueryDAO dao;

        public ImagingChannelsCreator(IImagingQueryDAO dao) {
            this.dao = dao;
        }

        public ImagingChannelsMap getOrCreateChannelsMap(ChannelOwner channelOwner, List<Channel> channels) {
            Map<String, Long> map = this.getOrCreateChannels(channelOwner, channels);
            return new ImagingChannelsMap(map);
        }

        private Map<String, Long> getOrCreateChannels(ChannelOwner channelOwner, List<Channel> channels) {
            ImagingChannelsCreator.fillMissingChannelColors(channels);
            if (channelOwner.tryGetExperimentId() != null) {
                long expId = channelOwner.tryGetExperimentId();
                List allChannels = this.dao.getChannelsByExperimentId(expId);
                if (allChannels.size() == 0) {
                    return this.createChannels(channelOwner, channels);
                }
                return this.updateExperimentChannels(expId, channels, allChannels);
            }
            List allChannels = this.dao.getChannelsByDatasetId(channelOwner.tryGetDatasetId());
            if (allChannels.size() == 0) {
                return this.createChannels(channelOwner, channels);
            }
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (ImgChannelDTO channelDTO : allChannels) {
                ImagingChannelsCreator.addChannel(map, channelDTO);
            }
            return map;
        }

        private Map<String, Long> updateExperimentChannels(long expId, List<Channel> channels, List<ImgChannelDTO> allChannels) {
            Map<String, ImgChannelDTO> existingChannels = ImagingChannelsCreator.asNameMap(allChannels);
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (Channel channel : channels) {
                ImgChannelDTO channelDTO = this.updateExperimentChannel(channel, expId, existingChannels);
                ImagingChannelsCreator.addChannel(map, channelDTO);
            }
            return map;
        }

        private Map<String, Long> createChannels(ChannelOwner channelOwner, List<Channel> channels) {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (Channel channel : channels) {
                ImgChannelDTO channelDTO = this.createChannel(channel, channelOwner);
                ImagingChannelsCreator.addChannel(map, channelDTO);
            }
            return map;
        }

        @Private
        static void fillMissingChannelColors(List<Channel> channels) {
            Set<Integer> usedColorsIndieces = ImagingChannelsCreator.createUsedColorsIndiecesSet(channels);
            for (Channel channel : channels) {
                if (channel.tryGetChannelColor() != null) continue;
                int colorIndex = ImagingChannelsCreator.getSmallestUnused(usedColorsIndieces);
                ChannelColor color = ChannelColor.createFromIndex(colorIndex);
                channel.setChannelColor(color);
                usedColorsIndieces.add(colorIndex);
            }
        }

        private static Set<Integer> createUsedColorsIndiecesSet(List<Channel> channels) {
            HashSet<Integer> usedColorsIndieces = new HashSet<Integer>();
            for (Channel channel : channels) {
                ChannelColorRGB channelColorRGB = channel.tryGetChannelColor();
                if (channelColorRGB == null) continue;
                ChannelColor channelColor = ImagingChannelsCreator.findNearestPlainChannelColor(channelColorRGB);
                usedColorsIndieces.add(channelColor.getColorOrderIndex());
            }
            return usedColorsIndieces;
        }

        @Private
        static ChannelColor findNearestPlainChannelColor(ChannelColorRGB color) {
            int r = color.getR();
            int g = color.getG();
            int b = color.getB();
            int max = r > g ? r : g;
            int n = max = b > max ? b : max;
            if (r == max) {
                if (r == g) {
                    return ChannelColor.RED_GREEN;
                }
                if (r == b) {
                    return ChannelColor.RED_BLUE;
                }
                return ChannelColor.RED;
            }
            if (g == max) {
                if (g == b) {
                    return ChannelColor.GREEN_BLUE;
                }
                return ChannelColor.GREEN;
            }
            return ChannelColor.BLUE;
        }

        private static int getSmallestUnused(Set<Integer> usedColorsIndieces) {
            int colorIndex = 0;
            while (usedColorsIndieces.contains(colorIndex)) {
                ++colorIndex;
            }
            return colorIndex;
        }

        private static void addChannel(Map<String, Long> map, ImgChannelDTO channelDTO) {
            map.put(channelDTO.getCode(), channelDTO.getId());
        }

        private static Map<String, ImgChannelDTO> asNameMap(List<ImgChannelDTO> channels) {
            HashMap<String, ImgChannelDTO> nameMap = new HashMap<String, ImgChannelDTO>();
            for (ImgChannelDTO channel : channels) {
                nameMap.put(channel.getCode(), channel);
            }
            return nameMap;
        }

        private ImgChannelDTO updateExperimentChannel(Channel channel, long expId, Map<String, ImgChannelDTO> existingChannels) {
            ImgChannelDTO channelDTO = ImagingChannelsCreator.makeChannelDTO(channel, ChannelOwner.createExperiment(expId));
            String channelCode = channelDTO.getCode();
            ImgChannelDTO existingChannel = existingChannels.get(channelCode);
            if (existingChannel == null) {
                throw ImagingChannelsCreator.createInvalidNewExperimentChannelException(expId, existingChannels, channelCode);
            }
            if (channelDTO.getWavelength() == null) {
                channelDTO.setWavelength(existingChannel.getWavelength());
            }
            if (existingChannel.getWavelength() != null && !existingChannel.getWavelength().equals(channelDTO.getWavelength())) {
                throw UserFailureException.fromTemplate((String)"There are already datasets registered for the experiment which use the same channel code, but with a different wavelength! Channel %s, old wavelength %d, new wavelength %d.", (Object[])new Object[]{channelCode, existingChannel.getWavelength(), channelDTO.getWavelength()});
            }
            channelDTO.setId(existingChannel.getId());
            this.dao.updateChannel(channelDTO);
            return channelDTO;
        }

        private static UserFailureException createInvalidNewExperimentChannelException(long expId, Map<String, ImgChannelDTO> existingChannels, String channelName) {
            return UserFailureException.fromTemplate((String)"Experiment with id '%d' has already some channels registered and does not have a channel with a code '%s'. Register a new experiment to use new channels. Available channel names in this experiment: %s.", (Object[])new Object[]{expId, channelName, existingChannels.keySet()});
        }

        private ImgChannelDTO createChannel(Channel channel, ChannelOwner channelOwner) {
            ImgChannelDTO channelDTO = ImagingChannelsCreator.makeChannelDTO(channel, channelOwner);
            long channelId = this.dao.addChannel(channelDTO);
            channelDTO.setId(channelId);
            this.saveChannelImageTransformations(channelId, channel.getAvailableTransformations());
            return channelDTO;
        }

        private void saveChannelImageTransformations(long channelId, ImageTransformation[] transformations) {
            if (transformations.length == 0) {
                return;
            }
            ArrayList<ImgImageTransformationDTO> transformationDTOs = new ArrayList<ImgImageTransformationDTO>();
            ImageTransformation[] imageTransformationArray = transformations;
            int n = transformations.length;
            int n2 = 0;
            while (n2 < n) {
                ImageTransformation transformation = imageTransformationArray[n2];
                ImgImageTransformationDTO transformationDTO = this.createTransformationDTO(transformation, channelId);
                if (transformationDTO.getIsDefault()) {
                    transformationDTOs.add(0, transformationDTO);
                } else {
                    transformationDTOs.add(transformationDTO);
                }
                ++n2;
            }
            this.dao.addImageTransformations(transformationDTOs);
        }

        private ImgImageTransformationDTO createTransformationDTO(ImageTransformation tr, long channelId) {
            return new ImgImageTransformationDTO(tr.getCode(), tr.getLabel(), tr.getDescription(), tr.isDefault(), channelId, tr.getImageTransformerFactory(), tr.isEditable());
        }

        private static ImgChannelDTO makeChannelDTO(Channel channel, ChannelOwner channelOwner) {
            ChannelColorRGB channelColor = channel.tryGetChannelColor();
            assert (channelColor != null) : "channel color should be specified at this point";
            return new ImgChannelDTO(channel.getCode(), channel.tryGetDescription(), channel.tryGetWavelength(), channelOwner.tryGetDatasetId(), channelOwner.tryGetExperimentId(), channel.getLabel(), channelColor.getR(), channelColor.getG(), channelColor.getB());
        }
    }

    public static class ImagingChannelsMap {
        private final Map<String, Long> channelsMap;

        public ImagingChannelsMap(Map<String, Long> channelsMap) {
            this.channelsMap = channelsMap;
        }

        public long getChannelId(String channelCode) {
            Long channelId = this.channelsMap.get(channelCode);
            if (channelId == null) {
                throw new UserFailureException("Undefined channel " + channelCode);
            }
            return channelId;
        }
    }
}

