-- Migration from 013 to 014

CREATE TABLE IMAGE_TRANSFORMATIONS (
    ID BIGSERIAL  NOT NULL,
    
    CODE NAME NOT NULL,
    LABEL NAME NOT NULL,
    DESCRIPTION character varying(1000),
	IS_EDITABLE BOOLEAN_CHAR NOT NULL,
    IMAGE_TRANSFORMER_FACTORY BYTEA NOT NULL,
		
    CHANNEL_ID TECH_ID NOT NULL,
    
    PRIMARY KEY (ID),
    CONSTRAINT FK_IMAGE_TRANSFORMATIONS_CHANNEL FOREIGN KEY (CHANNEL_ID) REFERENCES CHANNELS (ID) ON DELETE CASCADE ON UPDATE CASCADE,
    
    CONSTRAINT IMAGE_TRANSFORMATIONS_UK_1 UNIQUE(CODE, CHANNEL_ID)
);

CREATE INDEX IMAGE_TRANSFORMATIONS_CHANNELS_IDX ON IMAGE_TRANSFORMATIONS(CHANNEL_ID);

insert into IMAGE_TRANSFORMATIONS(ID, CODE, LABEL, DESCRIPTION, IMAGE_TRANSFORMER_FACTORY, IS_EDITABLE, CHANNEL_ID)
   select nextval('image_transformations_id_seq'), '_CUSTOM', 'Custom', 
   				'Custom image transformation defined with the Color Adjustment tool.',
          ch.IMAGE_TRANSFORMER_FACTORY, 'T', ch.ID
     from channels ch
    where ch.IMAGE_TRANSFORMER_FACTORY is not NULL;

alter table CHANNELS drop column IMAGE_TRANSFORMER_FACTORY;