/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.security.MD5ChecksumCalculator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import java.io.File;

public class DatasetLocationUtil {
    public static File getDatasetLocationPathCheckingIfExists(String dataSetCode, String shareId, DatabaseInstance databaseInstance, File storeDir) {
        String databaseUuid = databaseInstance.getUuid();
        File dataSetRootDirectory = DatasetLocationUtil.getDatasetLocationPath(storeDir, dataSetCode, shareId, databaseUuid);
        if (!dataSetRootDirectory.exists()) {
            throw new UserFailureException("Data set '" + dataSetCode + "' not found in the store.");
        }
        return dataSetRootDirectory;
    }

    public static File getDatasetLocationPath(File baseDir, String dataSetCode, String shareId, String instanceUUID) {
        File instanceDir = new File(new File(shareId), instanceUUID);
        File shardingDir = DatasetLocationUtil.createShardingDir(instanceDir, dataSetCode);
        File datasetDir = new File(shardingDir, dataSetCode);
        return new File(baseDir, datasetDir.getPath());
    }

    public static String getDatasetLocationPath(String dataSetCode, String instanceUUID) {
        File instanceDir = new File(instanceUUID);
        File shardingDir = DatasetLocationUtil.createShardingDir(instanceDir, dataSetCode);
        File datasetDir = new File(shardingDir, dataSetCode);
        return datasetDir.getPath();
    }

    private static File createShardingDir(File parentDir, String dataSetCode) {
        String checksum = MD5ChecksumCalculator.calculate(dataSetCode);
        File dirLevel1 = new File(parentDir, checksum.substring(0, 2));
        File dirLevel2 = new File(dirLevel1, checksum.substring(2, 4));
        File dirLevel3 = new File(dirLevel2, checksum.substring(4, 6));
        return dirLevel3;
    }
}

