/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import java.io.File;

public class PostgresInstallationDetectorUtils {
    private static final String PSQL = "psql";
    private static final String PG_DUMP = "pg_dump";

    public static boolean areCommandLineToolsOnPath() {
        return PostgresInstallationDetectorUtils.isValidCommand(PSQL) && PostgresInstallationDetectorUtils.isValidCommand(PG_DUMP);
    }

    public static boolean areCommandLineToolsInDir(String directoryName) {
        String psqlAbsolutePath = new File(directoryName, PSQL).getAbsolutePath();
        String pgDumpAbsolutePath = new File(directoryName, PG_DUMP).getAbsolutePath();
        return PostgresInstallationDetectorUtils.isValidCommand(psqlAbsolutePath) && PostgresInstallationDetectorUtils.isValidCommand(pgDumpAbsolutePath);
    }

    private static boolean isValidCommand(String command) {
        try {
            ProcessBuilder pb = new ProcessBuilder(command, "--help");
            pb.environment().putAll(System.getenv());
            Process proc = pb.start();
            int exitVal = proc.waitFor();
            return exitVal == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

