/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.data;

import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.binding.OsModel;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pack
implements Serializable {
    static final long serialVersionUID = -5458360562175088671L;
    private boolean hidden;
    public boolean loose;
    public boolean uninstall;
    public String name;
    public String id;
    public Set<String> installGroups = new HashSet<String>();
    public String excludeGroup = "";
    public String group;
    public String description;
    public List<OsModel> osConstraints = null;
    private String condition;
    public List<String> dependencies = null;
    public List<String> revDependencies = null;
    public boolean required;
    public long nbytes;
    public boolean preselected;
    public String parent;
    public PackColor color;
    public String packImgId;
    private List<String> validators = new ArrayList<String>();
    private static final double KILOBYTES = 1024.0;
    private static final double MEGABYTES = 1048576.0;
    private static final double GIGABYTES = 1.073741824E9;
    private static final DecimalFormat formatter = new DecimalFormat("#,###.##");

    public Pack(String name, String id, String description, List<OsModel> osConstraints, List<String> dependencies, boolean required, boolean preselected, boolean loose, String excludegroup, boolean uninstall) {
        this.name = name;
        this.id = id;
        this.description = description;
        this.osConstraints = osConstraints;
        this.dependencies = dependencies;
        this.required = required;
        this.preselected = preselected;
        this.loose = loose;
        this.excludeGroup = excludegroup;
        this.uninstall = uninstall;
        this.packImgId = null;
        this.condition = null;
        this.nbytes = 0L;
        this.color = PackColor.WHITE;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.description + ")";
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void addRevDep(String name0) {
        if (this.revDependencies == null) {
            this.revDependencies = new ArrayList<String>();
        }
        this.revDependencies.add(name0);
    }

    public String depString() {
        String name0;
        String text = "";
        if (this.dependencies == null) {
            return text;
        }
        int i = 0;
        while (i < this.dependencies.size() - 1) {
            name0 = this.dependencies.get(i);
            text = String.valueOf(text) + name0 + ",";
            ++i;
        }
        name0 = this.dependencies.get(this.dependencies.size() - 1);
        text = String.valueOf(text) + name0;
        return text;
    }

    public static String toByteUnitsString(long bytes) {
        if ((double)bytes < 1024.0) {
            return String.valueOf(String.valueOf(bytes)) + " bytes";
        }
        if ((double)bytes < 1048576.0) {
            double value = (double)bytes / 1024.0;
            return String.valueOf(formatter.format(value)) + " KB";
        }
        if ((double)bytes < 1.073741824E9) {
            double value = (double)bytes / 1048576.0;
            return String.valueOf(formatter.format(value)) + " MB";
        }
        double value = (double)bytes / 1.073741824E9;
        return String.valueOf(formatter.format(value)) + " GB";
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean hasCondition() {
        return this.condition != null;
    }

    public void addValidator(String validatorClassName) {
        this.validators.add(validatorClassName);
    }

    public List<String> getValidators() {
        return this.validators;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }
}

