/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.types.Resource;
import com.izforge.izpack.util.file.types.ResourceFactory;
import com.izforge.izpack.util.file.types.selectors.SelectorUtils;
import java.io.File;
import java.util.Date;
import java.util.Vector;

public class ResourceUtils {
    public static Resource[] selectOutOfDateSources(Resource[] source, FileNameMapper mapper, ResourceFactory targets) throws Exception {
        return ResourceUtils.selectOutOfDateSources(source, mapper, targets, FileUtils.getFileUtils().getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(Resource[] resources, FileNameMapper mapper, ResourceFactory targets, long granularity) throws Exception {
        long now = new Date().getTime() + granularity;
        Vector<Resource> vresult = new Vector<Resource>();
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            String[] targetnames;
            Resource resource = resourceArray[n2];
            if (resource.getLastModified() > now) {
                Debug.log("Warning: " + resource.getName() + " modified in the future.");
            }
            if ((targetnames = mapper.mapFileName(resource.getName().replace('/', File.separatorChar))) != null) {
                boolean added = false;
                StringBuffer targetList = new StringBuffer();
                int ctarget = 0;
                while (!added && ctarget < targetnames.length) {
                    Resource atarget = targets.getResource(targetnames[ctarget].replace(File.separatorChar, '/'));
                    if (!atarget.isExists()) {
                        Debug.log(String.valueOf(resource.getName()) + " added as " + atarget.getName() + " doesn't exist.");
                        vresult.addElement(resource);
                        added = true;
                    } else if (!atarget.isDirectory() && SelectorUtils.isOutOfDate(resource, atarget, (int)granularity)) {
                        Debug.log(String.valueOf(resource.getName()) + " added as " + atarget.getName() + " is outdated.");
                        vresult.addElement(resource);
                        added = true;
                    } else {
                        if (targetList.length() > 0) {
                            targetList.append(", ");
                        }
                        targetList.append(atarget.getName());
                    }
                    ++ctarget;
                }
                if (!added) {
                    Debug.log(String.valueOf(resource.getName()) + " omitted as " + targetList.toString() + (targetnames.length == 1 ? " is" : " are ") + " up to date.");
                }
            } else {
                Debug.log(String.valueOf(resource.getName()) + " skipped - don't know how to handle it");
            }
            ++n2;
        }
        Object[] result = new Resource[vresult.size()];
        vresult.copyInto(result);
        return result;
    }
}

