/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ControlledVocabularyPropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetKind;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataStore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityTypeInitializer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialTypeIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.PropertyTypeGroup;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Role;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleFetchOption;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ValidationPluginInfo;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSetUrl;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public class Translator {
    public static Role translate(RoleWithHierarchy role) {
        return Translator.translate(role.getRoleCode(), role.getRoleLevel().equals((Object)RoleWithHierarchy.RoleLevel.SPACE));
    }

    public static Role translate(RoleWithHierarchy.RoleCode roleCode, boolean spaceLevel) {
        return new Role(roleCode.name(), spaceLevel);
    }

    public static List<Project> translateProjects(List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project> projects) {
        ArrayList<Project> translated = new ArrayList<Project>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project project : projects) {
            translated.add(Translator.translate(project));
        }
        return translated;
    }

    public static DataStore translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore dataStore) {
        return new DataStore(dataStore.getCode(), dataStore.getDownloadUrl(), dataStore.getHostUrl());
    }

    public static List<DataStore> translateDataStores(List<ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore> dataStores) {
        ArrayList<DataStore> translated = new ArrayList<DataStore>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStore dataStore : dataStores) {
            translated.add(Translator.translate(dataStore));
        }
        return translated;
    }

    public static Project translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project project) {
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(project);
        return new Project(project.getId(), project.getPermId(), project.getSpace().getCode(), project.getCode(), registrationDetails);
    }

    public static List<Sample> translateSamples(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample> privateSamples) {
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample privateSample : privateSamples) {
            samples.add(Translator.translate(privateSample));
        }
        return samples;
    }

    public static Sample translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample privateSample) {
        Sample.SampleInitializer initializer = new Sample.SampleInitializer();
        initializer.setId(privateSample.getId());
        initializer.setStub(privateSample.isStub());
        initializer.setSpaceCode(privateSample.getSpace() != null ? privateSample.getSpace().getCode() : null);
        initializer.setPermId(privateSample.getPermId());
        initializer.setCode(privateSample.getCode());
        initializer.setIdentifier(privateSample.getIdentifier());
        if (privateSample.getSampleType() != null) {
            initializer.setSampleTypeId(privateSample.getSampleType().getId());
            initializer.setSampleTypeCode(privateSample.getSampleType().getCode());
        }
        List properties = privateSample.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        initializer.setRetrievedFetchOptions(EnumSet.of(SampleFetchOption.BASIC, SampleFetchOption.PROPERTIES, SampleFetchOption.METAPROJECTS));
        ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment experimentOrNull = privateSample.getExperiment();
        if (experimentOrNull != null) {
            initializer.setExperimentIdentifierOrNull(experimentOrNull.getIdentifier());
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(privateSample);
        initializer.setRegistrationDetails(registrationDetails);
        if (privateSample.getMetaprojects() != null) {
            for (Metaproject m : privateSample.getMetaprojects()) {
                initializer.addMetaproject(m);
            }
        }
        return new Sample(initializer);
    }

    public static List<Experiment> translateExperiments(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment> privateExperiments) {
        ArrayList<Experiment> experiments = new ArrayList<Experiment>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExpeiment : privateExperiments) {
            experiments.add(Translator.translate(privateExpeiment));
        }
        return experiments;
    }

    public static Experiment translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment privateExperiment) {
        Experiment.ExperimentInitializer initializer = new Experiment.ExperimentInitializer();
        initializer.setId(privateExperiment.getId());
        initializer.setPermId(privateExperiment.getPermId());
        initializer.setCode(privateExperiment.getCode());
        initializer.setIdentifier(privateExperiment.getIdentifier());
        initializer.setIsStub(privateExperiment.isStub());
        if (privateExperiment.getExperimentType() != null) {
            initializer.setExperimentTypeCode(privateExperiment.getExperimentType().getCode());
        }
        List properties = privateExperiment.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(privateExperiment);
        initializer.setRegistrationDetails(registrationDetails);
        if (privateExperiment.getMetaprojects() != null) {
            for (Metaproject metaproject : privateExperiment.getMetaprojects()) {
                initializer.addMetaproject(metaproject);
            }
        }
        return new Experiment(initializer);
    }

    public static DataSetType translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType dataSetType, HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms) {
        DataSetType.DataSetTypeInitializer initializer = new DataSetType.DataSetTypeInitializer();
        Translator.fillEntityTypeInitializerWithCommon((EntityType)dataSetType, vocabTerms, initializer);
        initializer.setDeletionDisallowed(dataSetType.isDeletionDisallow());
        initializer.setDataSetKind(Translator.translate(dataSetType.getDataSetKind()));
        initializer.setMainDataSetPattern(dataSetType.getMainDataSetPattern());
        initializer.setMainDataSetPath(dataSetType.getMainDataSetPath());
        return new DataSetType(initializer);
    }

    private static DataSetKind translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetKind dataSetKind) {
        return dataSetKind == null ? null : DataSetKind.valueOf(dataSetKind.name());
    }

    public static SampleType translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType sampleType, HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms) {
        SampleType.SampleTypeInitializer initializer = new SampleType.SampleTypeInitializer();
        Translator.fillEntityTypeInitializerWithCommon((EntityType)sampleType, vocabTerms, initializer);
        initializer.setListable(sampleType.isListable());
        initializer.setShowContainer(sampleType.isShowContainer());
        initializer.setShowParents(sampleType.isShowParents());
        initializer.setShowParentMetaData(sampleType.isShowParentMetadata());
        initializer.setUniqueSubcodes(sampleType.isSubcodeUnique());
        initializer.setAutomaticCodeGeneration(sampleType.isAutoGeneratedCode());
        initializer.setCodePrefix(sampleType.getGeneratedCodePrefix());
        return new SampleType(initializer);
    }

    public static ExperimentType translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType experimentType, HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms) {
        ExperimentType.ExperimentTypeInitializer initializer = new ExperimentType.ExperimentTypeInitializer();
        Translator.fillEntityTypeInitializerWithCommon((EntityType)experimentType, vocabTerms, initializer);
        return new ExperimentType(initializer);
    }

    private static void fillEntityTypeInitializerWithCommon(EntityType entityType, HashMap<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary, List<ControlledVocabularyPropertyType.VocabularyTerm>> vocabTerms, EntityTypeInitializer initializer) {
        initializer.setCode(entityType.getCode());
        initializer.setDescription(entityType.getDescription());
        initializer.setValidationPluginInfo(Translator.translate(entityType.getValidationScript()));
        List etpts = entityType.getAssignedPropertyTypes();
        Collections.sort(etpts);
        String sectionName = null;
        PropertyTypeGroup.PropertyTypeGroupInitializer groupInitializer = new PropertyTypeGroup.PropertyTypeGroupInitializer();
        for (EntityTypePropertyType etpt : etpts) {
            PropertyType.PropertyTypeInitializer ptInitializer;
            ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType propertyType;
            boolean isControlledVocabulary;
            if (etpt.isDynamic() || etpt.isManaged()) continue;
            String thisSectionName = etpt.getSection();
            if (!Translator.equals(sectionName, thisSectionName)) {
                Translator.addGroup(initializer, groupInitializer);
                groupInitializer = new PropertyTypeGroup.PropertyTypeGroupInitializer();
                sectionName = thisSectionName;
                groupInitializer.setName(sectionName);
            }
            boolean bl = isControlledVocabulary = (propertyType = etpt.getPropertyType()).getDataType().getCode() == DataTypeCode.CONTROLLEDVOCABULARY;
            if (isControlledVocabulary) {
                ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer cvptInitializer = new ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer();
                cvptInitializer.setVocabulary(propertyType.getVocabulary());
                cvptInitializer.setTerms(vocabTerms.get(propertyType.getVocabulary()));
                ptInitializer = cvptInitializer;
            } else {
                ptInitializer = new PropertyType.PropertyTypeInitializer();
            }
            ptInitializer.setDataType(propertyType.getDataType().getCode());
            ptInitializer.setCode(propertyType.getCode());
            ptInitializer.setLabel(propertyType.getLabel());
            ptInitializer.setDescription(propertyType.getDescription());
            ptInitializer.setMandatory(etpt.isMandatory());
            if (isControlledVocabulary) {
                groupInitializer.addPropertyType(new ControlledVocabularyPropertyType((ControlledVocabularyPropertyType.ControlledVocabularyPropertyTypeInitializer)ptInitializer));
                continue;
            }
            groupInitializer.addPropertyType(new PropertyType(ptInitializer));
        }
        Translator.addGroup(initializer, groupInitializer);
    }

    private static void addGroup(EntityTypeInitializer initializer, PropertyTypeGroup.PropertyTypeGroupInitializer groupInitializer) {
        if (!groupInitializer.getPropertyTypes().isEmpty()) {
            initializer.addPropertyTypeGroup(new PropertyTypeGroup(groupInitializer));
        }
    }

    private static boolean equals(String sectionName, String currentSectionName) {
        return sectionName == null ? sectionName == currentSectionName : sectionName.equals(currentSectionName);
    }

    private static ValidationPluginInfo translate(Script script) {
        if (script == null) {
            return null;
        }
        return new ValidationPluginInfo(script.getName(), script.getDescription());
    }

    public static List<ControlledVocabularyPropertyType.VocabularyTerm> translatePropertyTypeTerms(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<ControlledVocabularyPropertyType.VocabularyTerm> terms = new ArrayList<ControlledVocabularyPropertyType.VocabularyTerm>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm privateTerm : Translator.sortPrivateVocabularyTerms(privateTerms)) {
            EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(privateTerm);
            terms.add(new ControlledVocabularyPropertyType.VocabularyTerm(privateTerm.getCode(), privateTerm.getCodeOrLabel(), privateTerm.getOrdinal(), privateTerm.isOfficial(), registrationDetails));
        }
        return terms;
    }

    public static List<VocabularyTerm> translate(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<VocabularyTerm> terms = new ArrayList<VocabularyTerm>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm privateTerm : Translator.sortPrivateVocabularyTerms(privateTerms)) {
            EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetails(privateTerm);
            terms.add(new VocabularyTerm(privateTerm.getCode(), privateTerm.getCodeOrLabel(), privateTerm.getOrdinal(), privateTerm.isOfficial(), registrationDetails));
        }
        return terms;
    }

    private static ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> sortPrivateVocabularyTerms(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> privateTerms) {
        ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm> sortedTerms = new ArrayList<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm>(privateTerms);
        Collections.sort(sortedTerms, new Comparator<ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm>(){

            @Override
            public int compare(ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm o1, ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm o2) {
                if (o1.isOfficial() != o2.isOfficial()) {
                    return o1.isOfficial() != false ? -1 : 1;
                }
                return o1.getOrdinal().compareTo(o2.getOrdinal());
            }
        });
        return sortedTerms;
    }

    public static List<DataSet> translate(Iterable<AbstractExternalData> dataSets, EnumSet<DataSet.Connections> connectionsToGet) {
        ArrayList<DataSet> translated = new ArrayList<DataSet>();
        for (AbstractExternalData dataSet : dataSets) {
            translated.add(Translator.translate(dataSet, connectionsToGet));
        }
        return translated;
    }

    public static DataSet translate(AbstractExternalData externalDatum, EnumSet<DataSet.Connections> connectionsToGet) {
        return Translator.translate(externalDatum, connectionsToGet, true);
    }

    private static DataSet translate(AbstractExternalData externalDatum, EnumSet<DataSet.Connections> connectionsToGet, boolean doRecurseIntoContainedDataSets) {
        DataSet.DataSetInitializer initializer = new DataSet.DataSetInitializer();
        initializer.setId(externalDatum.getId());
        initializer.setCode(externalDatum.getCode());
        if (externalDatum.getExperiment() != null) {
            initializer.setExperimentIdentifier(externalDatum.getExperiment().getIdentifier());
        }
        initializer.setSampleIdentifierOrNull(externalDatum.getSampleIdentifier());
        if (externalDatum.getDataSetType() != null) {
            initializer.setDataSetTypeCode(externalDatum.getDataSetType().getCode());
        }
        initializer.setStorageConfirmed(externalDatum.isStorageConfirmation());
        initializer.setStub(externalDatum.isStub());
        List properties = externalDatum.getProperties();
        for (IEntityProperty prop : properties) {
            initializer.putProperty(prop.getPropertyType().getCode(), prop.tryGetAsString());
        }
        if (externalDatum.tryGetContainer() != null) {
            initializer.setContainerOrNull(Translator.translate((AbstractExternalData)externalDatum.tryGetContainer(), connectionsToGet, false));
        }
        initializer.setContainerDataSet(externalDatum.isContainer());
        if (externalDatum.isContainer() && doRecurseIntoContainedDataSets) {
            ContainerDataSet containerDataSet = externalDatum.tryGetAsContainerDataSet();
            ArrayList<DataSet> containedDataSets = new ArrayList<DataSet>(containerDataSet.getContainedDataSets().size());
            for (AbstractExternalData containedDataSet : containerDataSet.getContainedDataSets()) {
                containedDataSets.add(Translator.translate(containedDataSet, connectionsToGet, true));
            }
            initializer.setContainedDataSets(containedDataSets);
        }
        initializer.setLinkDataSet(externalDatum.isLinkData());
        if (externalDatum.isLinkData()) {
            LinkDataSet linkDataSet = externalDatum.tryGetAsLinkDataSet();
            initializer.setExternalDataSetCode(linkDataSet.getExternalCode());
            LinkDataSetUrl linkDataSetUrl = new LinkDataSetUrl(linkDataSet);
            initializer.setExternalDataSetLink(linkDataSetUrl.toString());
            initializer.setExternalDataManagementSystem(linkDataSet.getExternalDataManagementSystem());
        }
        initializer.setRetrievedConnections(connectionsToGet);
        for (DataSet.Connections connection : connectionsToGet) {
            switch (connection) {
                case PARENTS: {
                    Collection parents = externalDatum.getParents();
                    ArrayList<String> parentCodes = new ArrayList<String>();
                    for (AbstractExternalData parentDatum : CollectionUtils.nullSafe((Collection)parents)) {
                        parentCodes.add(parentDatum.getCode());
                    }
                    initializer.setParentCodes(parentCodes);
                    break;
                }
                case CHILDREN: {
                    Collection children = externalDatum.getChildren();
                    ArrayList<String> childrenCodes = new ArrayList<String>();
                    for (AbstractExternalData parentDatum : CollectionUtils.nullSafe((Collection)children)) {
                        childrenCodes.add(parentDatum.getCode());
                    }
                    initializer.setChildrenCodes(childrenCodes);
                }
            }
        }
        EntityRegistrationDetails registrationDetails = Translator.translateRegistrationDetailsWithModificationDate(externalDatum);
        initializer.setRegistrationDetails(registrationDetails);
        if (externalDatum.getMetaprojects() != null) {
            for (Metaproject mp : externalDatum.getMetaprojects()) {
                initializer.addMetaproject(mp);
            }
        }
        return new DataSet(initializer);
    }

    private static EntityRegistrationDetails translateRegistrationDetails(CodeWithRegistration<?> thingWithRegistrationDetails) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = Translator.createInitializer(thingWithRegistrationDetails);
        return new EntityRegistrationDetails(initializer);
    }

    private static EntityRegistrationDetails translateRegistrationDetailsWithModificationDate(CodeWithRegistrationAndModificationDate<?> thingWithRegistrationDetails) {
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = Translator.createInitializer(thingWithRegistrationDetails);
        initializer.setModificationDate(thingWithRegistrationDetails.getModificationDate());
        return new EntityRegistrationDetails(initializer);
    }

    private static EntityRegistrationDetails.EntityRegistrationDetailsInitializer createInitializer(CodeWithRegistration<?> thingWithRegistrationDetails) {
        Person registrator = thingWithRegistrationDetails.getRegistrator();
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer initializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        if (registrator != null) {
            initializer.setEmail(registrator.getEmail());
            initializer.setFirstName(registrator.getFirstName());
            initializer.setLastName(registrator.getLastName());
            initializer.setUserId(registrator.getUserId());
        }
        initializer.setRegistrationDate(thingWithRegistrationDetails.getRegistrationDate());
        return initializer;
    }

    private Translator() {
    }

    public static Vocabulary translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary privateVocabulary) {
        Vocabulary.VocabularyInitializer initializer = new Vocabulary.VocabularyInitializer();
        initializer.setId(privateVocabulary.getId());
        initializer.setCode(privateVocabulary.getCode());
        initializer.setDescription(privateVocabulary.getDescription());
        initializer.setChosenFromList(privateVocabulary.isChosenFromList());
        initializer.setInternalNamespace(privateVocabulary.isInternalNamespace());
        initializer.setManagedInternally(privateVocabulary.isManagedInternally());
        initializer.setUrlTemplate(privateVocabulary.getURLTemplate());
        initializer.setTerms(Translator.translate(privateVocabulary.getTerms()));
        return new Vocabulary(initializer);
    }

    public static Material translate(ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material, Map<Long, Material> materialsCache) {
        Material.MaterialInitializer mi = new Material.MaterialInitializer();
        mi.setId(material.getId());
        mi.setMaterialCode(material.getCode());
        MaterialTypeIdentifier typeIdentifier = new MaterialTypeIdentifier(material.getMaterialType().getCode());
        mi.setMaterialTypeIdentifier(typeIdentifier);
        material.getProperties();
        List originalProperties = material.getProperties();
        Map properties = EntityHelper.convertToStringMap((List)originalProperties);
        Map<String, Material> materialProperties = Translator.convertMaterialProperties(originalProperties, materialsCache);
        mi.setMaterialProperties(materialProperties);
        mi.setProperties(properties);
        mi.setRegistrationDetails(Translator.translateRegistrationDetails(material));
        if (material.getMetaprojects() != null) {
            for (Metaproject mp : material.getMetaprojects()) {
                mi.addMetaproject(mp);
            }
        }
        return new Material(mi);
    }

    private static Map<String, Material> convertMaterialProperties(List<IEntityProperty> properties, Map<Long, Material> materialsCache) {
        HashMap<String, Material> result = new HashMap<String, Material>();
        if (properties != null) {
            for (IEntityProperty property : properties) {
                ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material = property.getMaterial();
                if (material == null) continue;
                Material apiMaterial = materialsCache.get(material.getId());
                if (apiMaterial == null) {
                    apiMaterial = Translator.translate(material, materialsCache);
                }
                String propCode = property.getPropertyType().getCode();
                result.put(propCode, apiMaterial);
            }
        }
        return result;
    }

    public static List<Material> translateMaterials(Collection<ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material> materials) {
        HashMap<Long, Material> materialsCache = new HashMap<Long, Material>();
        LinkedList<Material> list = new LinkedList<Material>();
        for (ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material material : materials) {
            list.add(Translator.translate(material, materialsCache));
        }
        return list;
    }

    public static List<Attachment> translateAttachments(String sessionToken, IObjectId attachmentHolderId, AttachmentHolderPE attachmentHolderPE, List<AttachmentPE> attachments, boolean allVersions) {
        Collections.sort(attachments, new Comparator<AttachmentPE>(){

            @Override
            public int compare(AttachmentPE a1, AttachmentPE a2) {
                int fileNameCompare = a1.getFileName().compareTo(a2.getFileName());
                return fileNameCompare == 0 ? a2.getVersion() - a1.getVersion() : fileNameCompare;
            }
        });
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        String lastFilenameSeen = null;
        for (AttachmentPE attachmentPE : attachments) {
            String fileName = attachmentPE.getFileName();
            if (!allVersions && ObjectUtils.equals(lastFilenameSeen, (Object)fileName)) continue;
            result.add(Translator.translate(sessionToken, attachmentHolderId, attachmentHolderPE, attachmentPE));
            lastFilenameSeen = fileName;
        }
        return result;
    }

    private static Attachment translate(String sessionToken, IObjectId attachmentHolderId, AttachmentHolderPE attachmentHolderPE, AttachmentPE attachment) {
        Attachment.AttachmentInitializer initializer = new Attachment.AttachmentInitializer();
        initializer.setAttachmentHolderId(attachmentHolderId);
        initializer.setFileName(attachment.getFileName());
        initializer.setVersion(attachment.getVersion());
        initializer.setTitle(attachment.getTitle());
        initializer.setDescription(attachment.getDescription());
        EntityRegistrationDetails.EntityRegistrationDetailsInitializer regDetailsInitializer = new EntityRegistrationDetails.EntityRegistrationDetailsInitializer();
        regDetailsInitializer.setRegistrationDate(attachment.getRegistrationDate());
        regDetailsInitializer.setUserId(attachment.getRegistrator().getUserId());
        regDetailsInitializer.setFirstName(attachment.getRegistrator().getFirstName());
        regDetailsInitializer.setLastName(attachment.getRegistrator().getLastName());
        regDetailsInitializer.setEmail(attachment.getRegistrator().getEmail());
        initializer.setRegistrationDetails(new EntityRegistrationDetails(regDetailsInitializer));
        URLMethodWithParameters url = new URLMethodWithParameters("/openbis/openbis/attachment-download");
        url.addParameter("sessionID", (Object)sessionToken);
        url.addParameter("attachmentHolder", (Object)attachmentHolderPE.getAttachmentHolderKind().toString());
        if (attachmentHolderPE instanceof IIdHolder) {
            IIdHolder idHolder = (IIdHolder)attachmentHolderPE;
            url.addParameter("id", (Object)idHolder.getId().toString());
        } else {
            url.addParameter("permId", (Object)attachmentHolderPE.getPermId());
        }
        url.addParameter("fileName", (Object)attachment.getFileName());
        url.addParameter("version", (Object)Integer.toString(attachment.getVersion()));
        initializer.setDownloadLink(url.toString());
        return new Attachment(initializer);
    }
}

