/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1;

import ch.systemsx.cisd.common.api.retry.RetryCaller;
import ch.systemsx.cisd.common.api.retry.RetryProxyFactory;
import ch.systemsx.cisd.openbis.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.IGeneralInformationService;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1.IProteomicsDataApiFacade;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1.ProteomicsDataApiFacade;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.IProteomicsDataService;

public class FacadeFactory {
    private static final ServiceFinder SERVICE_FINDER = new ServiceFinder("openbis", "/rmi-proteomics-data-v1");
    private static final ServiceFinder GENERIC_INFO_SERVICE_FINDER = new ServiceFinder("openbis", "/rmi-general-information-v1");

    public static IProteomicsDataApiFacade create(final String serverURL, final String userID, final String password) {
        RetryCaller<IProteomicsDataApiFacade, RuntimeException> caller = new RetryCaller<IProteomicsDataApiFacade, RuntimeException>(){

            @Override
            protected IProteomicsDataApiFacade call() {
                IGeneralInformationService infoService = FacadeFactory.createGenericInfoService(serverURL);
                IProteomicsDataService service = FacadeFactory.createService(serverURL);
                String sessionToken = infoService.tryToAuthenticateForAllServices(userID, password);
                if (sessionToken == null) {
                    throw new IllegalArgumentException("User " + userID + " couldn't be authenticated");
                }
                ProteomicsDataApiFacade facade = new ProteomicsDataApiFacade(service, infoService, sessionToken);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IProteomicsDataApiFacade)caller.callWithRetry();
    }

    public static IProteomicsDataApiFacade create(final String serverURL, final String sessionToken) {
        RetryCaller<IProteomicsDataApiFacade, RuntimeException> caller = new RetryCaller<IProteomicsDataApiFacade, RuntimeException>(){

            @Override
            protected IProteomicsDataApiFacade call() {
                IProteomicsDataService service = FacadeFactory.createService(serverURL);
                IGeneralInformationService infoService = FacadeFactory.createGenericInfoService(serverURL);
                ProteomicsDataApiFacade facade = new ProteomicsDataApiFacade(service, infoService, sessionToken);
                return RetryProxyFactory.createProxy(facade);
            }
        };
        return (IProteomicsDataApiFacade)caller.callWithRetry();
    }

    private static IProteomicsDataService createService(String serverURL) {
        return SERVICE_FINDER.createService(IProteomicsDataService.class, serverURL);
    }

    private static IGeneralInformationService createGenericInfoService(String serverURL) {
        return GENERIC_INFO_SERVICE_FINDER.createService(IGeneralInformationService.class, serverURL);
    }
}

