/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Project;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1.FacadeFactory;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.api.v1.IProteomicsDataApiFacade;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataSet;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.DataStoreServerProcessingPluginInfo;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.Experiment;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.api.v1.dto.MsInjectionDataInfo;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProteomicsDataApiTest {
    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: <openbis-server-url> <login id> <password> <user id>");
            return;
        }
        String serverURL = args[0];
        String loginID = args[1];
        String password = args[2];
        String userID = args[3];
        IProteomicsDataApiFacade facade = FacadeFactory.create(serverURL, loginID, password);
        System.out.println("MS_INJECTION samples:");
        List<MsInjectionDataInfo> rawDataSamples = facade.listRawDataSamples(userID);
        for (MsInjectionDataInfo info : rawDataSamples) {
            Map<String, Date> latestDataSets = info.getLatestDataSetRegistrationDates();
            if (latestDataSets.isEmpty()) continue;
            System.out.println("   " + info.getMsInjectionSampleCode() + " -> " + info.getBiologicalSampleIdentifier() + " -> " + info.getBiologicalExperimentIdentifier());
            Experiment experiment = info.getBiologicalExperiment();
            if (experiment != null) {
                System.out.println("   biological experiment: " + experiment.getCode() + " " + experiment.getProperties());
            }
            System.out.println("   latest data sets: " + info.getLatestDataSetRegistrationDates());
            Set<DataSet> dataSets = info.getDataSets();
            Iterator iterator = dataSets.iterator();
            while (iterator.hasNext()) {
                DataSet dataSet = (DataSet)iterator.next();
                ProteomicsDataApiTest.print(dataSet, "         ");
            }
        }
        System.out.println("DSS processing plugins:");
        List<DataStoreServerProcessingPluginInfo> infos = facade.listDataStoreServerProcessingPluginInfos();
        String dataSetProcessingKey = null;
        for (DataStoreServerProcessingPluginInfo info : infos) {
            System.out.println("   key:" + info.getKey() + ", label:'" + info.getLabel() + "', data set types:" + info.getDatasetTypeCodes());
            if (!info.getDatasetTypeCodes().contains("PROT_RESULT")) continue;
            dataSetProcessingKey = info.getKey();
        }
        System.out.println("Projects:");
        List<Project> projects = facade.listProjects(userID);
        for (Project project : projects) {
            System.out.println(project);
        }
        System.out.println("Search Experiments:");
        List<Experiment> experiments = facade.listSearchExperiments(userID);
        long[] ids = new long[experiments.size()];
        int i = 0;
        while (i < experiments.size()) {
            Experiment experiment = experiments.get(i);
            System.out.println(String.valueOf(experiment.getSpaceCode()) + "/" + experiment.getProjectCode() + "/" + experiment.getCode() + " [" + experiment.getId() + ", " + experiment.getRegistrationDate() + "] " + experiment.getProperties());
            ids[i] = experiment.getId();
            ++i;
        }
        if (dataSetProcessingKey != null) {
            System.out.println("Process search data of " + ids.length + " experiments");
            facade.processSearchData(userID, dataSetProcessingKey, ids);
        }
        facade.logout();
    }

    private static void print(DataSet dataSet, String indentation) {
        System.out.println(String.valueOf(indentation) + dataSet.getCode() + " " + dataSet.getType() + " " + dataSet.getRegistrationDate() + " " + dataSet.getProperties());
        Set<DataSet> children = dataSet.getChildren();
        for (DataSet child : children) {
            ProteomicsDataApiTest.print(child, String.valueOf(indentation) + "  ");
        }
    }
}

