/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.jython;

import ch.systemsx.cisd.common.jython.JythonScript;
import ch.systemsx.cisd.common.jython.JythonScriptBatch;
import ch.systemsx.cisd.common.jython.JythonScriptBatches;
import ch.systemsx.cisd.common.jython.JythonScriptCommand;
import java.util.List;
import org.python.core.PyException;

public class JythonScriptSplitter {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int batchSize = 100;

    public List<String> split(String scriptToSplit) throws PyException {
        JythonScript script = new JythonScript(scriptToSplit);
        JythonScriptBatches batches = new JythonScriptBatches();
        JythonScriptBatch batch = new JythonScriptBatch();
        JythonScriptCommand command = new JythonScriptCommand();
        String[] stringArray = script.getLines();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (command.getSize() > 0 && command.isNextCommand(line)) {
                if (batch.getSize() > 0 && batch.getSize() + command.getSize() > this.getBatchSize()) {
                    batches.addBatch(batch);
                    batch = new JythonScriptBatch();
                }
                batch.addLines(command);
                command = new JythonScriptCommand();
                command.addLine(line);
            } else {
                command.addLine(line);
            }
            ++n2;
        }
        if (command.getSize() > 0) {
            batch.addLines(command);
        }
        if (batch.getSize() > 0) {
            batches.addBatch(batch);
        }
        return batches.getLines();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("Batch size must be > 0");
        }
        this.batchSize = batchSize;
    }
}

