/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogUtils;
import ch.systemsx.cisd.common.string.ReflectingStringUnescaperUnrestricted;
import org.apache.log4j.Logger;

public class ReflectingStringUnescaper {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ReflectingStringUnescaper.class);
    private static int MIN_TIME_LOGGED_MS = 100;

    public static <T> T unescapeDeep(T bean) {
        try {
            long time = System.currentTimeMillis();
            T result = ReflectingStringUnescaper.doUnescapeDeep(bean);
            long timeSpent = System.currentTimeMillis() - time;
            if (timeSpent >= (long)MIN_TIME_LOGGED_MS) {
                operationLog.info(String.valueOf(timeSpent) + "ms for unescaping " + (bean == null ? "" : bean.getClass().getSimpleName()));
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtils.logErrorWithFailingAssertion(operationLog, ex.toString());
            return null;
        }
    }

    private static <T> T doUnescapeDeep(T bean) {
        ReflectingStringUnescaperUnrestricted<T> escaper = new ReflectingStringUnescaperUnrestricted<T>(true, bean);
        return escaper.escape();
    }
}

