/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.WellMetadata;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonObject(value="PlateMetadata")
public class PlateMetadata
extends PlateIdentifier {
    private static final long serialVersionUID = 1L;
    private Geometry plateGeometry;
    private Map<String, String> properties;
    private List<WellMetadata> wells;

    public PlateMetadata(PlateIdentifier identifier, Geometry plateGeometry, Map<String, String> properties, List<WellMetadata> unsortedWells) {
        super(identifier.getPlateCode(), identifier.tryGetSpaceCode(), identifier.getPermId());
        this.plateGeometry = plateGeometry;
        this.properties = new HashMap<String, String>(properties);
        this.wells = this.sortWells(unsortedWells);
    }

    public Geometry getPlateGeometry() {
        return this.plateGeometry;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<WellMetadata> getWells() {
        return Collections.unmodifiableList(this.wells);
    }

    public WellMetadata getWell(int row, int col) {
        int idx = this.getWellIndexForRowAndCol(row, col);
        return this.wells.get(idx);
    }

    private int getWellIndexForRowAndCol(int row, int col) {
        return (row - 1) * this.plateGeometry.getNumberOfColumns() + (col - 1);
    }

    private List<WellMetadata> sortWells(List<WellMetadata> unsortedWells) {
        WellMetadata[] wellsArray = new WellMetadata[this.plateGeometry.getNumberOfRows() * this.plateGeometry.getNumberOfColumns()];
        for (WellMetadata well : unsortedWells) {
            int row = well.getWellPosition().getWellRow();
            int col = well.getWellPosition().getWellColumn();
            wellsArray[this.getWellIndexForRowAndCol((int)row, (int)col)] = well;
        }
        return Arrays.asList(wellsArray);
    }

    private PlateMetadata() {
        super(null, null);
    }

    private void setPlateGeometry(Geometry plateGeometry) {
        this.plateGeometry = plateGeometry;
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void setWells(List<WellMetadata> wells) {
        this.wells = wells;
    }
}

