/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.spring;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;

public class Bootstrapper
implements ApplicationContextAware,
InitializingBean {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Bootstrapper.class);
    private AbstractRefreshableConfigApplicationContext context;
    private String[] configLocations;
    private String[] conditionalConfigLocations;

    public void setConfigLocation(String configLocation) {
        this.configLocations = new String[]{configLocation};
    }

    public void setConditionalConfigLocations(String[] conditionalConfigLocations) {
        this.conditionalConfigLocations = conditionalConfigLocations;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (AbstractRefreshableConfigApplicationContext)applicationContext;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ArrayList<String> allConfigLocations = new ArrayList<String>();
        String[] stringArray = this.configLocations;
        int n = this.configLocations.length;
        int n2 = 0;
        while (n2 < n) {
            String configLocation = stringArray[n2];
            allConfigLocations.add(configLocation);
            ++n2;
        }
        if (this.conditionalConfigLocations != null) {
            stringArray = this.conditionalConfigLocations;
            n = this.conditionalConfigLocations.length;
            n2 = 0;
            while (n2 < n) {
                String condition;
                String conditionalConfigLocationString = stringArray[n2];
                int index = conditionalConfigLocationString.indexOf(":");
                if (index != -1 && Bootstrapper.evaluateCondition(condition = conditionalConfigLocationString.substring(0, index))) {
                    allConfigLocations.add(conditionalConfigLocationString.substring(index + 1));
                }
                ++n2;
            }
        }
        operationLog.info("Refreshing application context with " + allConfigLocations);
        this.context.setConfigLocations(allConfigLocations.toArray(new String[allConfigLocations.size()]));
        this.context.refresh();
        operationLog.info("Refreshed application context with " + allConfigLocations);
    }

    private static boolean evaluateCondition(String condition) {
        if (condition.contains("~")) {
            int index = condition.indexOf("~");
            String property = condition.substring(0, index);
            String containedText = condition.substring(index + 1);
            return property.contains(containedText);
        }
        return false;
    }
}

