/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRow;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableColumn;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableColumnDataType;
import ch.systemsx.cisd.openbis.plugin.query.shared.api.v1.dto.QueryTableModel;
import ch.systemsx.cisd.openbis.plugin.query.shared.translator.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class QueryTableModelTranslator {
    private final TableModel originalTableModel;

    public QueryTableModelTranslator(TableModel tableModel) {
        this.originalTableModel = tableModel;
    }

    public QueryTableModel translate() {
        return this.translate(this.originalTableModel);
    }

    private QueryTableModel translate(TableModel result) {
        List<TableModelColumnHeader> headers = result.getHeader();
        ArrayList<QueryTableColumn> translatedHeaders = new ArrayList<QueryTableColumn>();
        for (TableModelColumnHeader header : headers) {
            String title = header.getTitle();
            QueryTableColumnDataType dataType = Util.translate(header.getDataType());
            translatedHeaders.add(new QueryTableColumn(title, dataType));
        }
        QueryTableModel tableModel = new QueryTableModel(translatedHeaders);
        List<TableModelRow> rows = result.getRows();
        for (TableModelRow row : rows) {
            List<ISerializableComparable> values = row.getValues();
            Serializable[] translatedValues = new Serializable[values.size()];
            int i = 0;
            int n = values.size();
            while (i < n) {
                ISerializableComparable value = values.get(i);
                Object translatedValue = null;
                if (value instanceof IntegerTableCell) {
                    translatedValue = ((IntegerTableCell)value).getNumber();
                } else if (value instanceof DoubleTableCell) {
                    translatedValue = ((DoubleTableCell)value).getNumber();
                } else if (value instanceof StringTableCell) {
                    translatedValue = ((StringTableCell)value).toString();
                }
                translatedValues[i] = translatedValue;
                ++i;
            }
            tableModel.addRow(translatedValues);
        }
        return tableModel;
    }
}

