/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.PlateIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;

@JsonObject(value="Plate")
public class Plate
extends PlateIdentifier {
    private static final long serialVersionUID = 1L;
    private String experimentCode;
    private String projectCode;
    private ExperimentIdentifier experimentIdentifier;

    @Deprecated
    public Plate(String plateCode, String experimentCode, String projectCode, String spaceCode) {
        this(plateCode, spaceCode, null, new ExperimentIdentifier(spaceCode, projectCode, experimentCode, null));
    }

    public Plate(String plateCode, String spaceCode, String permId, ExperimentIdentifier experimentIdentifier) {
        super(plateCode, spaceCode, permId);
        this.experimentCode = experimentIdentifier.getExperimentCode();
        this.projectCode = experimentIdentifier.getProjectCode();
        this.experimentIdentifier = experimentIdentifier;
    }

    public ExperimentIdentifier getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.experimentIdentifier == null) {
            this.experimentIdentifier = new ExperimentIdentifier(this.experimentCode, this.projectCode, this.tryGetSpaceCode(), null);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " { Experiment: " + this.experimentIdentifier.getAugmentedCode() + " }";
    }

    private Plate() {
        super(null, null);
    }

    private void setExperimentCode(String experimentCode) {
        this.experimentCode = experimentCode;
    }

    private void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    private void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }
}

