/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.api.retry;

import ch.systemsx.cisd.common.api.retry.config.DefaultRetryConfiguration;
import ch.systemsx.cisd.common.api.retry.config.RetryConfiguration;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RetryCaller<T, E extends Throwable> {
    private RetryConfiguration configuration;
    private int retryCounter;
    private int waitingTime;

    public RetryCaller() {
        this(DefaultRetryConfiguration.getInstance());
    }

    public RetryCaller(RetryConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration was null");
        }
        if (configuration.getMaximumNumberOfRetries() < 0) {
            throw new IllegalArgumentException("MaximumNumberOfRetries must be >= 0");
        }
        if (configuration.getWaitingTimeBetweenRetries() <= 0) {
            throw new IllegalArgumentException("WaitingTimeBetweenRetries must be > 0");
        }
        if (configuration.getWaitingTimeBetweenRetriesIncreasingFactor() <= 0.0f) {
            throw new IllegalArgumentException("WaitingTimeBetweenRetriesIncreasingFactor must be > 0");
        }
        this.configuration = configuration;
        this.waitingTime = configuration.getWaitingTimeBetweenRetries();
    }

    protected abstract T call() throws E;

    public T callWithRetry() throws E {
        while (true) {
            try {
                T result = this.call();
                return result;
            }
            catch (RuntimeException e) {
                if (this.isCommunicationException(e)) {
                    if (this.shouldRetry()) {
                        System.err.println("Communication failed - will retry");
                        this.waitForRetry();
                        continue;
                    }
                    System.err.println("Communication failed - will NOT retry");
                    throw e;
                }
                throw e;
            }
            break;
        }
    }

    private boolean isCommunicationException(RuntimeException e) {
        if (e instanceof RemoteConnectFailureException) {
            return true;
        }
        if (e instanceof RemoteAccessException) {
            return e.getCause() instanceof SocketTimeoutException || e.getCause() instanceof SocketException;
        }
        return false;
    }

    private boolean shouldRetry() {
        return this.retryCounter < this.configuration.getMaximumNumberOfRetries();
    }

    private void waitForRetry() {
        try {
            Thread.sleep(this.waitingTime);
            this.waitingTime = (int)((float)this.waitingTime * this.configuration.getWaitingTimeBetweenRetriesIncreasingFactor());
            ++this.retryCounter;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }
}

