/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collections;

import ch.systemsx.cisd.common.collections.CompositeValidator;
import ch.systemsx.cisd.common.collections.IValidator;
import ch.systemsx.cisd.common.collections.RegExValidator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtils {
    private static final IValidator<Object> NOT_NULL_VALIDATOR = new IValidator<Object>(){

        @Override
        public final boolean isValid(Object object) {
            return object != null;
        }
    };
    private static final IValidator<Object> ALWAYS_TRUE = new IValidator<Object>(){

        @Override
        public final boolean isValid(Object object) {
            return true;
        }
    };

    private ValidatorUtils() {
    }

    public static final IValidator<String> createCaseInsensitivePatternValidator(String[] patterns) {
        assert (patterns != null) : "Unspecified patterns.";
        int length = patterns.length;
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                return ValidatorUtils.createCaseInsensitivePatternValidator(patterns[0]);
            }
        }
        CompositeValidator<String> validator = new CompositeValidator<String>();
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            validator.addValidator(ValidatorUtils.createCaseInsensitivePatternValidator(pattern));
            ++n2;
        }
        return validator;
    }

    public static final IValidator<String> createCaseInsensitivePatternValidator(String pattern) {
        if (pattern == null) {
            return null;
        }
        Pattern regEx = Pattern.compile(ValidatorUtils.convertToRegEx(pattern), 2);
        return new RegExValidator(regEx);
    }

    public static final <T> IValidator<T> getNotNullValidator() {
        return NOT_NULL_VALIDATOR;
    }

    public static final <T> IValidator<T> getAlwaysTrueValidator() {
        return ALWAYS_TRUE;
    }

    static final String convertToRegEx(String pattern) {
        assert (pattern != null);
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = pattern.toCharArray();
        boolean escape = false;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            String toAppend;
            char c = cArray[n2];
            if (c == '\\') {
                escape = true;
                toAppend = String.valueOf(c);
            } else if (c == '?' || c == '*') {
                if (!escape) {
                    toAppend = ".";
                    if (c == '*') {
                        toAppend = String.valueOf(toAppend) + "*";
                    }
                } else {
                    toAppend = String.valueOf(c);
                    escape = false;
                }
            } else {
                toAppend = String.valueOf(c);
                escape = false;
            }
            stringBuilder.append(toAppend);
            ++n2;
        }
        return stringBuilder.toString();
    }
}

