/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.filesystem.DelegateFreeSpaceProvider;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IFreeSpaceProvider;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class NonHangingFreeSpaceProvider
extends DelegateFreeSpaceProvider {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public NonHangingFreeSpaceProvider(IFreeSpaceProvider freeSpaceProvider) {
        super(freeSpaceProvider);
    }

    public final long freeSpaceKb(HostAwareFile path) throws IOException {
        Future<Long> future = this.executorService.submit(new FreeSpaceCallable(this.getFreeSpaceProvider(), path));
        ExecutionResult<Long> executionResult = ConcurrencyUtilities.getResult(future, 60000L);
        Long resultOrNull = executionResult.tryGetResult();
        if (resultOrNull != null) {
            return resultOrNull;
        }
        throw new IOException(String.format("Computing free space on '%s' failed: %s", path, executionResult));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FreeSpaceCallable
    implements Callable<Long> {
        private final IFreeSpaceProvider freeSpaceProvider;
        private final HostAwareFile path;

        FreeSpaceCallable(IFreeSpaceProvider freeSpaceProvider, HostAwareFile path) {
            this.freeSpaceProvider = freeSpaceProvider;
            this.path = path;
        }

        @Override
        public final Long call() throws Exception {
            return this.freeSpaceProvider.freeSpaceKb(this.path);
        }
    }
}

