/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io.hierarchical_content;

import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.hdf5.HDF5Container;
import ch.systemsx.cisd.common.hdf5.IHDF5ContainerReader;
import ch.systemsx.cisd.common.io.hierarchical_content.AbstractHierarchicalDirectoryContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.AbstractHierarchicalFileContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentNode;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.hdf5.HDF5FactoryProvider;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.io.HDF5DataSetRandomAccessFile;
import ch.systemsx.cisd.hdf5.io.HDF5IOAdapterFactory;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDF5ContainerBasedHierarchicalContentNode
extends DefaultFileBasedHierarchicalContentNode {
    private final HDF5Container hdf5Container;

    public HDF5ContainerBasedHierarchicalContentNode(IHierarchicalContent root, File hdf5ContainerFile) {
        super(root, hdf5ContainerFile);
        this.hdf5Container = new HDF5Container(hdf5ContainerFile);
    }

    private IHDF5ContainerReader createReader() {
        return this.hdf5Container.createSimpleReader();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public List<IHierarchicalContentNode> doGetChildNodes() {
        IHDF5ContainerReader reader = this.createReader();
        try {
            List<String> childPaths = reader.getGroupMembers("/");
            ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
            for (String childPath : childPaths) {
                result.add(this.getChildNode(reader, childPath));
            }
            ArrayList<IHierarchicalContentNode> arrayList = result;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    public IHierarchicalContentNode getChildNode(String childPath) {
        IHDF5ContainerReader reader = this.createReader();
        try {
            IHierarchicalContentNode iHierarchicalContentNode = this.getChildNode(reader, childPath);
            return iHierarchicalContentNode;
        }
        finally {
            reader.close();
        }
    }

    private IHierarchicalContentNode getChildNode(IHDF5ContainerReader reader, String childPath) {
        String fileName = FileUtilities.getFileNameFromRelativePath(childPath);
        if (reader.isGroup(childPath)) {
            return new HDF5GroupNode(this, childPath, fileName);
        }
        return new HDF5FileNode(this, childPath, fileName);
    }

    @Override
    public String toString() {
        return "HDF5ContainerBasedHierarchicalContentNode [root=" + this.root + ", container=" + this.hdf5Container.getHDF5File() + "]";
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.hdf5Container.getHDF5File().hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HDF5ContainerBasedHierarchicalContentNode)) {
            return false;
        }
        HDF5ContainerBasedHierarchicalContentNode other = (HDF5ContainerBasedHierarchicalContentNode)obj;
        if (!this.hdf5Container.getHDF5File().equals(other.hdf5Container.getHDF5File())) {
            return false;
        }
        return this.root.equals(other.root);
    }

    private static HDF5DataSetBasedContent extractFileContent(File hdf5File, String dataSetPath) {
        return new HDF5DataSetBasedContent(hdf5File, dataSetPath);
    }

    public static class HDF5DataSetBasedContent
    implements Closeable {
        private final File hdf5File;
        private final String dataSetPath;
        private final String name;
        private final boolean exists;
        private final long size;
        private final List<HDF5DataSetRandomAccessFile> randomAccessFiles;

        public HDF5DataSetBasedContent(File hdf5File, String dataSetPath) {
            this.hdf5File = hdf5File;
            this.dataSetPath = dataSetPath;
            this.name = FileUtilities.getFileNameFromRelativePath(dataSetPath);
            IHDF5Reader reader = HDF5FactoryProvider.get().openForReading(hdf5File);
            if (reader.exists(dataSetPath) && reader.isDataSet(dataSetPath)) {
                this.exists = true;
                this.size = reader.getSize(dataSetPath);
            } else {
                this.exists = false;
                this.size = 0L;
            }
            reader.close();
            this.randomAccessFiles = new ArrayList<HDF5DataSetRandomAccessFile>();
        }

        public String tryGetName() {
            return this.name;
        }

        public long getSize() {
            return this.size;
        }

        public boolean exists() {
            return this.exists;
        }

        public IRandomAccessFile getReadOnlyRandomAccessFile() {
            HDF5DataSetRandomAccessFile randomAccessFile = HDF5IOAdapterFactory.asRandomAccessFileReadOnly((File)this.hdf5File, (String)this.dataSetPath);
            this.randomAccessFiles.add(randomAccessFile);
            return randomAccessFile;
        }

        public InputStream getInputStream() {
            return new AdapterIInputStreamToInputStream((IInputStream)this.getReadOnlyRandomAccessFile());
        }

        public void close() {
            for (HDF5DataSetRandomAccessFile raFile : this.randomAccessFiles) {
                raFile.close();
            }
        }
    }

    class HDF5FileNode
    extends AbstractHierarchicalFileContentNode {
        private final String relativePath;
        private final String fileName;
        private HDF5DataSetBasedContent contentOrNull;
        private final HDF5ContainerBasedHierarchicalContentNode containerNode;

        public HDF5FileNode(HDF5ContainerBasedHierarchicalContentNode containerNode, String relativePath, String fileName) {
            this.containerNode = containerNode;
            this.relativePath = relativePath;
            this.fileName = fileName;
        }

        public String getName() {
            return this.fileName;
        }

        public String doGetRelativePath() {
            return String.valueOf(this.containerNode.getRelativePath()) + File.separator + this.relativePath;
        }

        public boolean exists() {
            return this.getContent().exists();
        }

        public boolean isDirectory() {
            return false;
        }

        public long getLastModified() {
            return HDF5ContainerBasedHierarchicalContentNode.this.file.lastModified();
        }

        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This is not a normal file node.");
        }

        protected long doGetFileLength() {
            return this.getContent().getSize();
        }

        protected IRandomAccessFile doGetFileContent() {
            return this.getContent().getReadOnlyRandomAccessFile();
        }

        protected InputStream doGetInputStream() {
            return this.getContent().getInputStream();
        }

        private HDF5DataSetBasedContent getContent() {
            if (this.contentOrNull == null) {
                this.contentOrNull = HDF5ContainerBasedHierarchicalContentNode.extractFileContent(HDF5ContainerBasedHierarchicalContentNode.this.file, this.relativePath);
            }
            return this.contentOrNull;
        }

        public String toString() {
            return "HDF5FileNode [containerPath=" + this.containerNode.getRelativePath() + ", relativePath=" + this.relativePath + ", fileName=" + this.fileName + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class HDF5GroupNode
    extends AbstractHierarchicalDirectoryContentNode {
        private final String relativePath;
        private final String groupName;
        private final HDF5ContainerBasedHierarchicalContentNode containerNode;

        public HDF5GroupNode(HDF5ContainerBasedHierarchicalContentNode containerNode, String relativePath, String groupName) {
            this.containerNode = containerNode;
            this.relativePath = relativePath;
            this.groupName = groupName;
        }

        @Override
        public String getName() {
            return this.groupName;
        }

        @Override
        public String doGetRelativePath() {
            return String.valueOf(this.containerNode.getRelativePath()) + File.separator + this.relativePath;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public long getLastModified() {
            return HDF5ContainerBasedHierarchicalContentNode.this.file.lastModified();
        }

        @Override
        public File getFile() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("This is not a normal directory node.");
        }

        @Override
        protected List<IHierarchicalContentNode> doGetChildNodes() {
            IHDF5ContainerReader reader = HDF5ContainerBasedHierarchicalContentNode.this.createReader();
            try {
                ArrayList<IHierarchicalContentNode> result = new ArrayList<IHierarchicalContentNode>();
                List<String> children = reader.getGroupMembers(this.relativePath);
                for (String childName : children) {
                    String newRelativePath = String.valueOf(this.relativePath) + File.separator + childName;
                    if (reader.isGroup(newRelativePath)) {
                        result.add(new HDF5GroupNode(this.containerNode, newRelativePath, childName));
                        continue;
                    }
                    result.add(new HDF5FileNode(this.containerNode, newRelativePath, childName));
                }
                ArrayList<IHierarchicalContentNode> arrayList = result;
                return arrayList;
            }
            finally {
                reader.close();
            }
        }

        public String toString() {
            return "HDF5GroupNode [containerPath=" + this.containerNode.getRelativePath() + ", relativePath=" + this.relativePath + ", groupName=" + this.groupName + "]";
        }
    }
}

