/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ExcelRowTokenizer;
import ch.systemsx.cisd.common.parser.ILine;
import org.apache.poi.ss.usermodel.Row;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelRow
implements ILine<Row> {
    private Row row;
    private String text;

    public ExcelRow(Row row) {
        this.row = row;
    }

    @Override
    public String getText() {
        if (this.text == null) {
            this.text = ExcelRow.toString(this.row);
        }
        return this.text;
    }

    @Override
    public int getNumber() {
        return this.row.getRowNum();
    }

    @Override
    public Row getObject() {
        return this.row;
    }

    private static String toString(Row row) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = new ExcelRowTokenizer().tokenize(row);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() > 0) {
                sb.append("\t");
            }
            sb.append(s);
            ++n2;
        }
        return sb.toString();
    }
}

