/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractExecutor;
import ch.systemsx.cisd.openbis.dss.client.api.cli.DataSetArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDataSetDss;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDataSetExecutor<A extends DataSetArguments>
extends AbstractExecutor<A> {
    AbstractDataSetExecutor(A arguments, AbstractDssCommand<A> command) {
        super(arguments, command);
    }

    @Override
    protected final ResultCode doExecute(IDssComponent component) {
        IDataSetDss dataSet = component.getDataSet(((DataSetArguments)this.arguments).getDataSetCode());
        FileInfoDssDTO[] fileInfos = this.getFileInfos(dataSet);
        this.handle(fileInfos, dataSet);
        return ResultCode.OK;
    }

    private FileInfoDssDTO[] getFileInfos(IDataSetDss dataSet) {
        return dataSet.listFiles(((DataSetArguments)this.arguments).getRequestedPath(), ((DataSetArguments)this.arguments).isRecursive());
    }

    protected abstract void handle(FileInfoDssDTO[] var1, IDataSetDss var2);
}

