/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.IServer;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.authorization.ISessionProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.ReturnValueFilter;
import ch.systemsx.cisd.openbis.generic.shared.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AtomicOperationsPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetCodeCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.DataSetUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ExistingSampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ExistingSpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ListSampleCriteriaPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ListSamplesByPropertyPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.NewSamplesWithTypePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleTechIdPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.ProjectValidator;
import ch.systemsx.cisd.openbis.generic.shared.authorization.validator.SampleValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ArchiverDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentFetchOptions;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListMaterialCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationResult;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetShareId;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServerInfo;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityCollectionForCreationOrUpdate;
import ch.systemsx.cisd.openbis.generic.shared.dto.ListSamplesByPropertyCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IETLLIMSService
extends IServer,
ISessionProvider {
    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public DatabaseInstance getHomeDatabaseInstance(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public void registerDataStoreServer(String var1, DataStoreServerInfo var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public Experiment tryToGetExperiment(String var1, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) ExperimentIdentifier var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Material tryGetMaterial(String var1, MaterialIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public SampleIdentifier tryToGetSampleIdentifier(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public ExperimentType getExperimentType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Sample tryGetSampleWithExperiment(String var1, @AuthorizationGuard(guardClass=ExistingSampleOwnerIdentifierPredicate.class) SampleIdentifier var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Collection<VocabularyTerm> listVocabularyTerms(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public SampleType getSampleType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public DataSetTypeWithVocabularyTerms getDataSetType(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listDataSetsByExperimentID(String var1, @AuthorizationGuard(guardClass=AbstractTechIdPredicate.ExperimentTechIdPredicate.class) TechId var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listDataSetsBySampleID(String var1, @AuthorizationGuard(guardClass=SampleTechIdPredicate.class) TechId var2, boolean var3) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listDataSetsByCode(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @ReturnValueFilter(validatorClass=SampleValidator.class)
    public List<Sample> listSamples(String var1, @AuthorizationGuard(guardClass=ListSampleCriteriaPredicate.class) ListSampleCriteria var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public IEntityProperty[] tryToGetPropertiesOfTopSampleRegisteredFor(String var1, @AuthorizationGuard(guardClass=SampleOwnerIdentifierPredicate.class) SampleIdentifier var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerEntities(String var1, EntityCollectionForCreationOrUpdate var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT})
    public long registerExperiment(String var1, @AuthorizationGuard(guardClass=NewExperimentPredicate.class) NewExperiment var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public void registerSamples(String var1, @AuthorizationGuard(guardClass=NewSamplesWithTypePredicate.class) List<NewSamplesWithTypes> var2, String var3) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public long registerSample(String var1, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample var2, String var3) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    public void updateSample(String var1, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerDataSet(String var1, @AuthorizationGuard(guardClass=SampleOwnerIdentifierPredicate.class) SampleIdentifier var2, NewExternalData var3) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void registerDataSet(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ExperimentIdentifier var2, NewExternalData var3) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public void checkInstanceAdminAuthorization(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_POWER_USER})
    public void checkSpacePowerUserAuthorization(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void checkDataSetAccess(String var1, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER})
    public void checkDataSetCollectionAccess(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public ExternalData tryGetDataSet(String var1, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public String createDataSetCode(String var1) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public String createPermId(String var1) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public long drawANewUniqueID(String var1) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Sample> listSamplesByCriteria(String var1, @AuthorizationGuard(guardClass=ListSamplesByPropertyPredicate.class) ListSamplesByPropertyCriteria var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DataSetShareId> listShareIds(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<SimpleDataSetInformationDTO> listDataSets(String var1, String var2) throws UserFailureException;

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<DeletedDataSet> listDeletedDataSets(String var1, Long var2, Date var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listAvailableDataSets(String var1, String var2, ArchiverDataSetCriteria var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listDataSets(String var1, String var2, TrackingDataSetCriteria var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperiments(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) ProjectIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperiments(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ExperimentIdentifier> var2, ExperimentFetchOptions var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Experiment> listExperimentsForProjects(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) List<ProjectIdentifier> var2, ExperimentFetchOptions var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @ReturnValueFilter(validatorClass=ProjectValidator.class)
    public List<Project> listProjects(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Material> listMaterials(String var1, ListMaterialCriteria var2, boolean var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void addPropertiesToDataSet(String var1, List<NewProperty> var2, String var3, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var4) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateShareIdAndSize(String var1, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String var2, String var3, long var4) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateDataSetStatuses(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2, DataSetArchivingStatus var3, boolean var4) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public boolean compareAndSetDataSetStatus(String var1, String var2, DataSetArchivingStatus var3, DataSetArchivingStatus var4, boolean var5) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int archiveDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2, boolean var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public int unarchiveDatasets(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_USER})
    public void checkSpaceAccess(String var1, @AuthorizationGuard(guardClass=SpaceIdentifierPredicate.class) SpaceIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public ExternalData tryGetDataSetForServer(String var1, @AuthorizationGuard(guardClass=DataSetCodePredicate.class) String var2) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> generateCodes(String var1, String var2, int var3);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Person> listAdministrators(String var1);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Person tryPersonWithUserIdOrEmail(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public Sample registerSampleAndDataSet(String var1, @AuthorizationGuard(guardClass=NewSamplePredicate.class) NewSample var2, NewExternalData var3, String var4) throws UserFailureException;

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public Sample updateSampleAndRegisterDataSet(String var1, @AuthorizationGuard(guardClass=SampleUpdatesPredicate.class) SampleUpdatesDTO var2, NewExternalData var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE, DatabaseModificationKind.ObjectKind.PROJECT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.DATA_SET})
    public AtomicEntityOperationResult performEntityOperations(String var1, @AuthorizationGuard(guardClass=AtomicOperationsPredicate.class) AtomicEntityOperationDetails var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Space tryGetSpace(String var1, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) SpaceIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public Project tryGetProject(String var1, @AuthorizationGuard(guardClass=ExistingSpaceIdentifierPredicate.class) ProjectIdentifier var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<Sample> searchForSamples(String var1, SearchCriteria var2);

    @Transactional(readOnly=true)
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> searchForDataSets(String var1, SearchCriteria var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.EXPERIMENT})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    public void removeDataSetsPermanently(String var1, @AuthorizationGuard(guardClass=DataSetCodeCollectionPredicate.class) List<String> var2, String var3);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.EXPERIMENT, DatabaseModificationKind.ObjectKind.SAMPLE, DatabaseModificationKind.ObjectKind.DATA_SET})
    public void updateDataSet(String var1, @AuthorizationGuard(guardClass=DataSetUpdatesPredicate.class) DataSetUpdatesDTO var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<String> getTrustedCrossOriginDomains(String var1);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.DATA_SET})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.POSTREGISTRATION_QUEUE})
    public void setStorageConfirmed(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.POSTREGISTRATION_QUEUE})
    public void markSuccessfulPostRegistration(String var1, String var2);

    @Transactional
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ETL_SERVER})
    public List<ExternalData> listDataSetsForPostRegistration(String var1, String var2);
}

