/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.InitializingChecks;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Experiment
implements Serializable,
IIdentifierHolder {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String permId;
    private String code;
    private String identifier;
    private String experimentTypeCode;
    private EntityRegistrationDetails registrationDetails;
    private HashMap<String, String> properties;

    public Experiment(ExperimentInitializer initializer) {
        InitializingChecks.checkValidLong(initializer.getId(), "Unspecified id.");
        this.id = initializer.getId();
        InitializingChecks.checkValidString(initializer.getPermId(), "Unspecified permanent id.");
        this.permId = initializer.getPermId();
        InitializingChecks.checkValidString(initializer.getCode(), "Unspecified code.");
        this.code = initializer.getCode();
        InitializingChecks.checkValidString(initializer.getIdentifier(), "Unspecified identifier.");
        this.identifier = initializer.getIdentifier();
        InitializingChecks.checkValidString(initializer.getExperimentTypeCode(), "Unspecified experiment type code.");
        this.experimentTypeCode = initializer.getExperimentTypeCode();
        InitializingChecks.checkValidRegistrationDetails(initializer.getRegistrationDetails(), "Unspecified entity registration details.");
        this.registrationDetails = initializer.getRegistrationDetails();
        this.properties = initializer.getProperties();
    }

    public Long getId() {
        return this.id;
    }

    public String getPermId() {
        return this.permId;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public String getExperimentTypeCode() {
        return this.experimentTypeCode;
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Experiment)) {
            return false;
        }
        EqualsBuilder builder = new EqualsBuilder();
        Experiment other = (Experiment)obj;
        builder.append((Object)this.getId(), (Object)other.getId());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getId());
        return builder.toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append((Object)this.getIdentifier());
        builder.append((Object)this.getExperimentTypeCode());
        builder.append(this.getProperties());
        return builder.toString();
    }

    private Experiment() {
    }

    private void setId(Long id) {
        this.id = id;
    }

    private void setPermId(String permId) {
        this.permId = permId;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    private void setExperimentTypeCode(String experimentTypeCode) {
        this.experimentTypeCode = experimentTypeCode;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    private void setProperties(HashMap<String, String> properties) {
        this.properties = properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExperimentInitializer {
        private Long id;
        private String permId;
        private String code;
        private String identifier;
        private String experimentTypeCode;
        private EntityRegistrationDetails registrationDetails;
        private HashMap<String, String> properties = new HashMap();

        public void setId(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public void setPermId(String permId) {
            this.permId = permId;
        }

        public String getPermId() {
            return this.permId;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setExperimentTypeCode(String experimentTypeCode) {
            this.experimentTypeCode = experimentTypeCode;
        }

        public String getExperimentTypeCode() {
            return this.experimentTypeCode;
        }

        public HashMap<String, String> getProperties() {
            return this.properties;
        }

        public void putProperty(String propCode, String value) {
            this.properties.put(propCode, value);
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }
    }
}

