/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;

public final class RoleWithIdentifier {
    RoleWithHierarchy role;
    private final DatabaseInstancePE databaseInstanceOrNull;
    private final SpacePE spaceOrNull;

    @Private
    RoleWithIdentifier(RoleWithHierarchy.RoleLevel roleLevel, RoleWithHierarchy.RoleCode roleName, DatabaseInstancePE databaseInstanceOrNull, SpacePE spaceOrNull) {
        this.role = RoleWithHierarchy.valueOf(roleLevel, roleName);
        if (RoleWithHierarchy.RoleLevel.SPACE.equals(roleLevel)) {
            assert (spaceOrNull != null) : "Unspecified identifier";
            assert (databaseInstanceOrNull == null);
        } else {
            assert (spaceOrNull == null);
            assert (databaseInstanceOrNull != null) : "Unspecified identifier";
        }
        this.databaseInstanceOrNull = databaseInstanceOrNull;
        this.spaceOrNull = spaceOrNull;
    }

    public final DatabaseInstancePE getAssignedDatabaseInstance() {
        assert (this.databaseInstanceOrNull != null);
        return this.databaseInstanceOrNull;
    }

    public final SpacePE getAssignedSpace() {
        assert (this.spaceOrNull != null);
        return this.spaceOrNull;
    }

    public static final RoleWithIdentifier createRole(RoleAssignmentPE roleAssignment) {
        assert (roleAssignment != null) : "Unspecified role assignment";
        RoleWithHierarchy.RoleLevel roleLevel = RoleWithIdentifier.figureRoleLevel(roleAssignment);
        RoleWithHierarchy.RoleCode roleName = roleAssignment.getRole();
        DatabaseInstancePE databaseInstance = roleAssignment.getDatabaseInstance();
        SpacePE space = roleAssignment.getSpace();
        return new RoleWithIdentifier(roleLevel, roleName, databaseInstance, space);
    }

    private static RoleWithHierarchy.RoleLevel figureRoleLevel(RoleAssignmentPE roleAssignment) {
        RoleWithHierarchy.RoleLevel roleLevel;
        assert (roleAssignment.getDatabaseInstance() == null || roleAssignment.getSpace() == null) : "Either the space or the database instance must be null";
        RoleWithHierarchy.RoleLevel roleLevel2 = roleAssignment.getDatabaseInstance() != null ? RoleWithHierarchy.RoleLevel.INSTANCE : (roleLevel = roleAssignment.getSpace() != null ? RoleWithHierarchy.RoleLevel.SPACE : null);
        assert (roleLevel != null) : "Either the space or the database instance must not be null";
        return roleLevel;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("<").append(this.createOwnerDescription()).append(">");
        return builder.toString();
    }

    private String createOwnerDescription() {
        if (this.databaseInstanceOrNull != null) {
            return IdentifierHelper.createDatabaseInstanceIdentifier(this.databaseInstanceOrNull).toString();
        }
        return IdentifierHelper.createGroupIdentifier(this.spaceOrNull).toString();
    }

    public RoleWithHierarchy.RoleLevel getRoleLevel() {
        return this.role.getRoleLevel();
    }

    public RoleWithHierarchy.RoleCode getRoleName() {
        return this.role.getRoleCode();
    }

    public RoleWithHierarchy getRole() {
        return this.role;
    }
}

