/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IExpressionUpdates;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractExpressionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionPredicate<T>
extends AbstractPredicate<T> {
    private final String description;
    protected IAuthorizationDataProvider authorizationDataProvider;

    protected abstract AbstractExpressionPE<?> convert(T var1);

    public AbstractExpressionPredicate(String description) {
        this.description = description;
    }

    @Override
    public final String getCandidateDescription() {
        return this.description;
    }

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.authorizationDataProvider = provider;
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, T value) {
        AbstractExpressionPE<?> gridExpression = this.convert(value);
        boolean matching = AbstractExpressionPredicate.isMatching(person, gridExpression);
        if (matching) {
            return Status.OK;
        }
        String userId = person.getUserId();
        return Status.createError(this.createErrorMsg(gridExpression, userId));
    }

    private static boolean isMatching(PersonPE person, AbstractExpressionPE<?> gridExpression) {
        return AbstractExpressionPredicate.isRegistrator(person, gridExpression) || AbstractExpressionPredicate.isInstanceAdmin(person, gridExpression.getDatabaseInstance());
    }

    private String createErrorMsg(AbstractExpressionPE<?> gridExpression, String userId) {
        return String.format("User '%s' does not have enough privileges to perform " + this.description + " '%s'. " + "One needs to be either registrator or database instance admin.", userId, gridExpression);
    }

    private static boolean isRegistrator(PersonPE person, AbstractExpressionPE<?> gridExpression) {
        return person.equals(gridExpression.getRegistrator());
    }

    private static boolean isInstanceAdmin(PersonPE person, DatabaseInstancePE databaseInstance) {
        Set<RoleAssignmentPE> roleAssignments = person.getAllPersonRoles();
        for (RoleAssignmentPE roleAssignment : roleAssignments) {
            DatabaseInstancePE roleInstance = roleAssignment.getDatabaseInstance();
            if (!databaseInstance.equals(roleInstance)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGridCustomColumnPredicate
    extends AbstractExpressionPredicate<TechId> {
        public DeleteGridCustomColumnPredicate() {
            super("delete grid custom column");
        }

        @Override
        public AbstractExpressionPE<?> convert(TechId techId) {
            return this.authorizationDataProvider.getGridCustomColumn(techId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteGridCustomFilterPredicate
    extends AbstractExpressionPredicate<TechId> {
        public DeleteGridCustomFilterPredicate() {
            super("delete grid custom filter");
        }

        @Override
        public AbstractExpressionPE<?> convert(TechId techId) {
            return this.authorizationDataProvider.getGridCustomFilter(techId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateGridCustomColumnPredicate
    extends AbstractExpressionPredicate<IExpressionUpdates> {
        public UpdateGridCustomColumnPredicate() {
            super("update grid custom column");
        }

        @Override
        public AbstractExpressionPE<?> convert(IExpressionUpdates criteria) {
            TechId techId = TechId.create(criteria);
            return this.authorizationDataProvider.getGridCustomColumn(techId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateGridCustomFilterPredicate
    extends AbstractExpressionPredicate<IExpressionUpdates> {
        public UpdateGridCustomFilterPredicate() {
            super("update grid custom filter");
        }

        @Override
        public AbstractExpressionPE<?> convert(IExpressionUpdates criteria) {
            TechId techId = TechId.create(criteria);
            return this.authorizationDataProvider.getGridCustomFilter(techId);
        }
    }
}

