/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.IPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPredicate<T>
implements IPredicate<T> {
    AbstractPredicate() {
    }

    public abstract String getCandidateDescription();

    protected abstract Status doEvaluation(PersonPE var1, List<RoleWithIdentifier> var2, T var3);

    protected boolean isNullValueAllowed() {
        return false;
    }

    @Override
    public final Status evaluate(PersonPE person, List<RoleWithIdentifier> allowedRoles, T valueOrNull) {
        assert (person != null) : "Unspecified person";
        assert (allowedRoles != null) : "Unspecified allowed roles";
        if (valueOrNull == null && !this.isNullValueAllowed()) {
            throw UserFailureException.fromTemplate("No %s specified.", this.getCandidateDescription());
        }
        try {
            return this.doEvaluation(person, allowedRoles, valueOrNull);
        }
        catch (DataAccessException ex) {
            throw new UserFailureException(ex.getMessage(), ex);
        }
    }
}

