/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKindAndTypeCode;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WildcardSupportingMap<T> {
    private final ArrayList<WildcardedThingMapping<T>> mappings = new ArrayList();

    protected void addThingMapping(EntityKindAndTypeCode entityKindAndCode, T thing) {
        this.mappings.add(new WildcardedThingMapping(entityKindAndCode, thing));
    }

    protected T tryThing(EntityKindAndTypeCode entityKindAndCode) {
        for (WildcardedThingMapping<T> mapping : this.mappings) {
            if (!mapping.matchesEntityKindAndTypeCode(entityKindAndCode)) continue;
            return mapping.getThing();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WildcardedThingMapping<T> {
        private final EntityKindAndTypeCode entityKindAndCode;
        private final T thing;

        private WildcardedThingMapping(EntityKindAndTypeCode entityKindAndCode, T thing) {
            this.entityKindAndCode = entityKindAndCode;
            this.thing = thing;
        }

        public T getThing() {
            return this.thing;
        }

        boolean matchesEntityKindAndTypeCode(EntityKindAndTypeCode otherEntityKindAndTypeCode) {
            if (!this.entityKindAndCode.entityKindsMatch(otherEntityKindAndTypeCode)) {
                return false;
            }
            return otherEntityKindAndTypeCode.getEntityTypeCode().matches(this.entityKindAndCode.getEntityTypeCode());
        }
    }
}

