/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.annotation.CollectionMapping;
import ch.systemsx.cisd.openbis.generic.shared.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractableData
extends Code<ExtractableData> {
    private static final long serialVersionUID = 32L;
    private Date productionDate;
    private String dataProducerCode;
    private List<String> parentDataSetCodes = new ArrayList<String>();
    private List<NewProperty> dataSetProperties = new ArrayList<NewProperty>();

    public Date getProductionDate() {
        return this.productionDate;
    }

    public void setProductionDate(Date productionDate) {
        this.productionDate = productionDate;
    }

    public String getDataProducerCode() {
        return this.dataProducerCode;
    }

    public void setDataProducerCode(String dataProducerCode) {
        this.dataProducerCode = dataProducerCode;
    }

    public final List<String> getParentDataSetCodes() {
        return this.parentDataSetCodes;
    }

    @CollectionMapping(collectionClass=ArrayList.class, elementClass=String.class)
    public final void setParentDataSetCodes(List<String> parentDataSetCodes) {
        ArrayList<String> newParentDataSetCodes = new ArrayList<String>(parentDataSetCodes);
        this.parentDataSetCodes = newParentDataSetCodes;
    }

    @CollectionMapping(collectionClass=ArrayList.class, elementClass=NewProperty.class)
    public void setDataSetProperties(List<NewProperty> dataSetProperties) {
        ArrayList<NewProperty> newDataSetProperties = new ArrayList<NewProperty>(dataSetProperties);
        this.dataSetProperties = newDataSetProperties;
    }

    public List<NewProperty> getDataSetProperties() {
        return this.dataSetProperties;
    }

    public boolean removeDataSetProperty(String propertyCode) {
        return EntityHelper.removeProperty(this.dataSetProperties, propertyCode);
    }
}

