/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.validator.NotNull;

@Entity
@Table(name="sample_relationships", uniqueConstraints={@UniqueConstraint(columnNames={"sample_id_parent", "sample_id_child", "relationship_id"})})
public class SampleRelationshipPE
implements Serializable {
    private static final long serialVersionUID = 32L;
    protected transient Long id;
    private SamplePE parentSample;
    private SamplePE childSample;
    private RelationshipTypePE relationship;
    private DeletionPE deletion;

    @Deprecated
    public SampleRelationshipPE() {
    }

    public SampleRelationshipPE(SamplePE parentSample, SamplePE childSample, RelationshipTypePE relationship) {
        this.parentSample = parentSample;
        this.childSample = childSample;
        this.relationship = relationship;
        parentSample.addChildRelationship(this);
        childSample.addParentRelationship(this);
    }

    @NotNull(message="Parent can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="sample_id_parent")
    public SamplePE getParentSample() {
        return this.parentSample;
    }

    public void setParentSample(SamplePE parentSample) {
        this.parentSample = parentSample;
    }

    @NotNull(message="Child can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="sample_id_child")
    public SamplePE getChildSample() {
        return this.childSample;
    }

    public void setChildSample(SamplePE childSample) {
        this.childSample = childSample;
    }

    @NotNull(message="Relationship can not be null.")
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="relationship_id")
    public RelationshipTypePE getRelationship() {
        return this.relationship;
    }

    public void setRelationship(RelationshipTypePE relationship) {
        this.relationship = relationship;
    }

    @SequenceGenerator(name="SAMPLE_RELATIONSHIP_ID_SEQ", sequenceName="SAMPLE_RELATIONSHIP_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SAMPLE_RELATIONSHIP_ID_SEQ")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }
}

