/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ProjectTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExperimentTranslator {
    private ExperimentTranslator() {
    }

    private static void setProperties(ExperimentPE experiment, Experiment result, boolean rawManagedProperties) {
        if (experiment.isPropertiesInitialized()) {
            if (rawManagedProperties) {
                result.setProperties(EntityPropertyTranslator.translateRaw(experiment.getProperties(), new HashMap<PropertyTypePE, PropertyType>()));
            } else {
                result.setProperties(EntityPropertyTranslator.translate(experiment.getProperties(), new HashMap<PropertyTypePE, PropertyType>()));
            }
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, LoadableFields ... withFields) {
        return ExperimentTranslator.translate(experiment, baseIndexURL, false, withFields);
    }

    public static final Experiment translate(ExperimentPE experiment, String baseIndexURL, boolean rawManagedProperties, LoadableFields ... withFields) {
        if (experiment == null) {
            return null;
        }
        Experiment result = new Experiment();
        result.setId(HibernateUtils.getId(experiment));
        result.setModificationDate(experiment.getModificationDate());
        result.setCode(experiment.getCode());
        result.setPermId(experiment.getPermId());
        result.setPermlink(PermlinkUtilities.createPermlinkURL(baseIndexURL, EntityKind.EXPERIMENT, experiment.getPermId()));
        result.setExperimentType(ExperimentTranslator.translate(experiment.getExperimentType(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setIdentifier(experiment.getIdentifier());
        result.setProject(ProjectTranslator.translate(experiment.getProject()));
        result.setRegistrationDate(experiment.getRegistrationDate());
        result.setRegistrator(PersonTranslator.translate(experiment.getRegistrator()));
        result.setDeletion(DeletionTranslator.translate(experiment.getDeletion()));
        LoadableFields[] loadableFieldsArray = withFields;
        int n = withFields.length;
        int n2 = 0;
        while (n2 < n) {
            LoadableFields field = loadableFieldsArray[n2];
            switch (field) {
                case PROPERTIES: {
                    ExperimentTranslator.setProperties(experiment, result, rawManagedProperties);
                    break;
                }
                case ATTACHMENTS: {
                    result.setAttachments(AttachmentTranslator.translate(experiment.getAttachments(), baseIndexURL));
                    break;
                }
            }
            ++n2;
        }
        return result;
    }

    public static final List<Experiment> translate(List<ExperimentPE> experiments, String baseIndexURL) {
        ArrayList<Experiment> result = new ArrayList<Experiment>(experiments.size());
        for (ExperimentPE experiment : experiments) {
            HibernateUtils.initialize(experiment.getProperties());
            result.add(ExperimentTranslator.translate(experiment, baseIndexURL, true, LoadableFields.PROPERTIES));
        }
        return result;
    }

    public static final ExperimentType translate(ExperimentTypePE experimentType, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ExperimentType result = new ExperimentType();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(experimentType.getDatabaseInstance()));
        result.setExperimentTypePropertyTypes(ExperimentTypePropertyTypeTranslator.translate(experimentType.getExperimentTypePropertyTypes(), result, cacheOrNull));
        return result;
    }

    public static final ExperimentTypePE translate(ExperimentType experimentType) {
        ExperimentTypePE result = new ExperimentTypePE();
        result.setCode(experimentType.getCode());
        result.setDescription(experimentType.getDescription());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(experimentType.getDatabaseInstance()));
        return result;
    }

    public static final List<ExperimentType> translate(List<ExperimentTypePE> experimentTypes) {
        ArrayList<ExperimentType> result = new ArrayList<ExperimentType>(experimentTypes.size());
        for (ExperimentTypePE experimentType : experimentTypes) {
            result.add(ExperimentTranslator.translate(experimentType, new HashMap<PropertyTypePE, PropertyType>()));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LoadableFields {
        ATTACHMENTS,
        PROPERTIES;

    }
}

