/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDataSetHelper {
    public static final List<SimpleDataSetInformationDTO> translate(List<ExternalData> externalData) {
        if (externalData == null) {
            return null;
        }
        ArrayList<SimpleDataSetInformationDTO> result = new ArrayList<SimpleDataSetInformationDTO>();
        for (ExternalData ed : externalData) {
            if (!(ed instanceof DataSet)) continue;
            DataSet dataSet = (DataSet)ed;
            result.add(SimpleDataSetHelper.translate(dataSet));
        }
        return result;
    }

    private static SimpleDataSetInformationDTO translate(DataSet data) {
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDataStoreCode(data.getDataStore().getCode());
        result.setDataSetCode(data.getCode());
        result.setSpeedHint(data.getSpeedHint());
        result.setDataSetShareId(data.getShareId());
        result.setDataSetLocation(data.getLocation());
        result.setDataSetSize(data.getSize());
        result.setDatabaseInstanceCode(data.getExperiment().getProject().getSpace().getInstance().getCode());
        result.setExperimentCode(data.getExperiment().getCode());
        result.setProjectCode(data.getExperiment().getProject().getCode());
        result.setGroupCode(data.getExperiment().getProject().getSpace().getCode());
        result.setSampleCode(data.getSampleCode());
        result.setDataSetType(data.getDataSetType().getCode());
        return result;
    }

    public static SimpleDataSetInformationDTO translate(DatasetDescription datasetDescription) {
        SimpleDataSetInformationDTO result = new SimpleDataSetInformationDTO();
        result.setDatabaseInstanceCode(datasetDescription.getDatabaseInstanceCode());
        result.setDataSetCode(datasetDescription.getDataSetCode());
        result.setSpeedHint(datasetDescription.getSpeedHint());
        result.setDataSetLocation(datasetDescription.getDataSetLocation());
        result.setDataSetSize(datasetDescription.getDataSetSize());
        result.setDataSetType(datasetDescription.getDataSetTypeCode());
        result.setExperimentCode(datasetDescription.getExperimentCode());
        result.setGroupCode(datasetDescription.getSpaceCode());
        result.setProjectCode(datasetDescription.getProjectCode());
        result.setSampleCode(datasetDescription.getSampleCode());
        return result;
    }
}

