/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

@JsonObject(value="Project")
public final class Project
implements Serializable,
IIdentifierHolder {
    private static final long serialVersionUID = 1L;
    private String spaceCode;
    private String code;
    private EntityRegistrationDetails registrationDetails;

    public Project(String spaceCode, String code) {
        this(spaceCode, code, null);
    }

    public Project(String spaceCode, String code, EntityRegistrationDetails registrationDetails) {
        if (spaceCode == null || spaceCode.length() == 0) {
            throw new IllegalArgumentException("Unspecified space code.");
        }
        this.spaceCode = spaceCode;
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException("Unspecified code.");
        }
        this.code = code;
        this.registrationDetails = registrationDetails;
    }

    public String getSpaceCode() {
        return this.spaceCode;
    }

    public String getCode() {
        return this.code;
    }

    @Override
    @JsonIgnore
    public String getIdentifier() {
        return "/" + this.spaceCode + "/" + this.code;
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Project)) {
            return false;
        }
        Project project = (Project)obj;
        return project.spaceCode.equals(this.spaceCode) && project.code.equals(this.code);
    }

    public int hashCode() {
        return 37 * this.spaceCode.hashCode() + this.code.hashCode();
    }

    public String toString() {
        return this.getIdentifier();
    }

    private Project() {
    }

    private void setSpaceCode(String spaceCode) {
        this.spaceCode = spaceCode;
    }

    private void setCode(String code) {
        this.code = code;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }
}

