/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import java.util.Date;

public class DateTableCell
implements ISerializableComparable {
    private static final long serialVersionUID = 32L;
    private long dateTime;

    public DateTableCell(long dateTime) {
        this.dateTime = dateTime;
    }

    public DateTableCell(Date date) {
        this.dateTime = date.getTime();
    }

    public Date getDateTime() {
        return new Date(this.dateTime);
    }

    @Override
    public int compareTo(ISerializableComparable o) {
        if (o instanceof DateTableCell) {
            DateTableCell cell = (DateTableCell)o;
            return this.dateTime < cell.dateTime ? -1 : (this.dateTime > cell.dateTime ? 1 : 0);
        }
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DateTableCell && this.dateTime == ((DateTableCell)obj).dateTime;
    }

    public int hashCode() {
        return (int)this.dateTime;
    }

    public String toString() {
        return new Date(this.dateTime).toString();
    }

    private DateTableCell() {
    }
}

