/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import java.io.Serializable;
import java.util.List;

public class DetailedSearchField
implements Serializable {
    private static final long serialVersionUID = 32L;
    private DetailedSearchFieldKind kind;
    private String codeOrNull;
    private List<String> allEntityPropertyCodesOrNull;

    public static DetailedSearchField createAnyField(List<String> allEntityPropertyCodes) {
        assert (allEntityPropertyCodes != null) : "property codes not set";
        return new DetailedSearchField(DetailedSearchFieldKind.ANY_FIELD, null, allEntityPropertyCodes);
    }

    public static DetailedSearchField createAnyPropertyField(List<String> allEntityPropertyCodes) {
        assert (allEntityPropertyCodes != null) : "property codes not set";
        return new DetailedSearchField(DetailedSearchFieldKind.ANY_PROPERTY, null, allEntityPropertyCodes);
    }

    public static DetailedSearchField createPropertyField(String propertyCode) {
        assert (propertyCode != null) : "property code not set";
        return new DetailedSearchField(DetailedSearchFieldKind.PROPERTY, propertyCode);
    }

    public static DetailedSearchField createAttributeField(IAttributeSearchFieldKind attributeFieldKind) {
        assert (attributeFieldKind != null) : "attribute not set";
        return DetailedSearchField.createAttributeField(attributeFieldKind.getCode());
    }

    public static DetailedSearchField createRegistratorField() {
        return new DetailedSearchField(DetailedSearchFieldKind.REGISTRATOR, null);
    }

    private static DetailedSearchField createAttributeField(String code) {
        assert (code != null) : "code not set";
        return new DetailedSearchField(DetailedSearchFieldKind.ATTRIBUTE, code);
    }

    private DetailedSearchField() {
        this(null, null);
    }

    private DetailedSearchField(DetailedSearchFieldKind kind, String codeOrNull) {
        this(kind, codeOrNull, null);
    }

    private DetailedSearchField(DetailedSearchFieldKind kind, String codeOrNull, List<String> allEntityPropertyCodesOrNull) {
        this.kind = kind;
        this.codeOrNull = codeOrNull;
        this.allEntityPropertyCodesOrNull = allEntityPropertyCodesOrNull;
    }

    public DetailedSearchFieldKind getKind() {
        return this.kind;
    }

    public String getAttributeCode() {
        assert (this.kind == DetailedSearchFieldKind.ATTRIBUTE);
        return this.codeOrNull;
    }

    public String getPropertyCode() {
        assert (this.kind == DetailedSearchFieldKind.PROPERTY);
        return this.codeOrNull;
    }

    public List<String> getAllEntityPropertyCodesOrNull() {
        assert (this.kind == DetailedSearchFieldKind.ANY_PROPERTY || this.kind == DetailedSearchFieldKind.ANY_FIELD);
        return this.allEntityPropertyCodesOrNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getKind());
        if (this.codeOrNull != null) {
            sb.append(" " + this.codeOrNull);
        }
        return sb.toString();
    }
}

