/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkModel;

public class DssLinkTableCell
implements ISerializableComparable {
    private static final long serialVersionUID = 32L;
    private String linkText;
    private LinkModel linkModel;

    public DssLinkTableCell(String linkText, LinkModel linkModel) {
        this.linkText = linkText;
        this.linkModel = linkModel;
    }

    private DssLinkTableCell() {
    }

    public void setLinkModel(LinkModel linkModel) {
        this.linkModel = linkModel;
    }

    public LinkModel getLinkModel() {
        return this.linkModel;
    }

    @Override
    public int compareTo(ISerializableComparable o) {
        return this.toString().compareTo(String.valueOf(o));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DssLinkTableCell)) {
            return false;
        }
        DssLinkTableCell other = (DssLinkTableCell)obj;
        return other.toString().equals(this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return DssLinkTableCell.getLinkUrl(this.linkModel, "sessionToken");
    }

    public String getHtmlString(String sessionId) {
        return URLMethodWithParameters.createEmbededLinkHtml(this.linkText, DssLinkTableCell.getLinkUrl(this.linkModel, sessionId));
    }

    public static String getLinkUrl(LinkModel linkModel, String sessionId) {
        linkModel.setSessionId(sessionId);
        URLMethodWithParameters urlMethod = new URLMethodWithParameters(String.valueOf(linkModel.getSchemeAndDomain()) + "/" + linkModel.getPath());
        for (LinkModel.LinkParameter param : linkModel.getParameters()) {
            urlMethod.addParameter(param.getName(), param.getValue());
        }
        return urlMethod.toString();
    }
}

