/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import java.io.Serializable;
import java.util.Collection;

public final class ListMaterialCriteria
implements Serializable {
    private static final long serialVersionUID = 32L;
    private MaterialType materialTypeOrNull;
    private Collection<Long> materialIdsOrNull;
    private Collection<MaterialIdentifier> materialIdentifiersOrNull;

    public ListMaterialCriteria() {
    }

    public static ListMaterialCriteria createFromMaterialType(MaterialType materialType) {
        return new ListMaterialCriteria(materialType, null, null);
    }

    public static ListMaterialCriteria createFromMaterialIds(Collection<Long> materialIds) {
        return new ListMaterialCriteria(null, materialIds, null);
    }

    public static ListMaterialCriteria createFromMaterialIdentifiers(Collection<MaterialIdentifier> materialIdentifiers) {
        return new ListMaterialCriteria(null, null, materialIdentifiers);
    }

    private ListMaterialCriteria(MaterialType materialTypeOrNull, Collection<Long> materialIdsOrNull, Collection<MaterialIdentifier> materialIdentifiersOrNull) {
        boolean codes;
        boolean ids = materialIdsOrNull != null;
        boolean types = materialTypeOrNull != null;
        boolean bl = codes = materialIdentifiersOrNull != null;
        assert (!(ids && types && codes));
        assert (ids ^ types ^ codes);
        this.materialTypeOrNull = materialTypeOrNull;
        this.materialIdsOrNull = materialIdsOrNull;
        this.materialIdentifiersOrNull = materialIdentifiersOrNull;
    }

    public MaterialType tryGetMaterialType() {
        return this.materialTypeOrNull;
    }

    public Collection<Long> tryGetMaterialIds() {
        return this.materialIdsOrNull;
    }

    public Collection<MaterialIdentifier> tryGetMaterialIdentifiers() {
        return this.materialIdentifiersOrNull;
    }
}

