/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.common.annotation.CollectionMapping;
import ch.systemsx.cisd.openbis.generic.shared.basic.IAttachmentHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IPermIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeWithRegistrationAndModificationDate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Sample
extends CodeWithRegistrationAndModificationDate<Sample>
implements IEntityWithDeletionInformation,
Comparable<Sample>,
IEntityInformationHolderWithProperties,
IAttachmentHolder,
IIdAndCodeHolder,
IPermIdHolder {
    private static final long serialVersionUID = 32L;
    public static final Sample[] EMPTY_ARRAY = new Sample[0];
    private SampleType sampleType;
    private Space space;
    private DatabaseInstance databaseInstance;
    private String identifier;
    private Sample container;
    private Set<Sample> parents = new TreeSet<Sample>();
    private List<Sample> containedSamples = new ArrayList<Sample>();
    private List<IEntityProperty> properties;
    private Deletion deletion;
    private Experiment experiment;
    private Long id;
    private List<Attachment> attachments;
    private String permId;
    private String permlink;
    private String searchlink;
    private String subCode;

    public String getSubCode() {
        return this.subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public String getPermlink() {
        return this.permlink;
    }

    public void setPermlink(String permlink) {
        this.permlink = permlink;
    }

    public String getSearchlink() {
        return this.searchlink;
    }

    public void setSearchlink(String searchlink) {
        this.searchlink = searchlink;
    }

    @Override
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.SAMPLE;
    }

    public SampleType getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(SampleType sampleType) {
        this.sampleType = sampleType;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }

    public DatabaseInstance getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstance databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    public void setIdentifier(String sampleIdentifer) {
        this.identifier = sampleIdentifer;
    }

    public Sample getContainer() {
        return this.container;
    }

    public void setContainer(Sample container) {
        this.container = container;
    }

    public Set<Sample> getParents() {
        return this.parents;
    }

    public void setParents(Set<Sample> parents) {
        this.parents = parents;
    }

    public void addParent(Sample parent) {
        this.parents.add(parent);
    }

    public List<Sample> tryGetContainedSamples() {
        return this.containedSamples;
    }

    public void setContainedSample(List<Sample> containedSamples) {
        this.containedSamples = containedSamples;
    }

    public Sample getGeneratedFrom() {
        if (this.parents.size() == 0) {
            return null;
        }
        if (this.parents.size() > 1) {
            throw new IllegalStateException("Sample " + this.getIdentifier() + " has more than one parent");
        }
        return this.parents.iterator().next();
    }

    public void setGeneratedFrom(Sample generatedFrom) {
        this.parents = new TreeSet<Sample>();
        this.parents.add(generatedFrom);
    }

    @Override
    public List<IEntityProperty> getProperties() {
        return this.properties;
    }

    @CollectionMapping(collectionClass=ArrayList.class, elementClass=EntityProperty.class)
    public void setProperties(List<IEntityProperty> properties) {
        this.properties = properties;
    }

    public final void setDeletion(Deletion deletion) {
        this.deletion = deletion;
    }

    public final Experiment getExperiment() {
        return this.experiment;
    }

    public final void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public final Deletion getDeletion() {
        return this.deletion;
    }

    @Override
    public final int compareTo(Sample o) {
        return this.getIdentifier().compareTo(o.getIdentifier());
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public EntityType getEntityType() {
        return this.getSampleType();
    }

    @Override
    public EntityKind getEntityKind() {
        return EntityKind.SAMPLE;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }

    @Override
    public String getPermId() {
        return this.permId;
    }

    public String toString() {
        return "Sample [sampleType=" + this.sampleType + ", space=" + this.space + ", databaseInstance=" + this.databaseInstance + ", identifier=" + this.identifier + ", container=" + this.container + ", parents=" + this.parents + ", properties=" + this.properties + ", deletion=" + this.deletion + ", experiment=" + this.experiment + ", id=" + this.id + ", modificationDate=" + this.getModificationDate() + ", attachments=" + this.attachments + ", permId=" + this.permId + ", permlink=" + this.permlink + ", searchlink=" + this.searchlink + ", subCode=" + this.subCode + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sample)) {
            return false;
        }
        Sample other = (Sample)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }
}

