/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetBatchUpdateDetails;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewDataSet;

public class UpdatedDataSet
extends NewDataSet {
    private static final long serialVersionUID = 32L;
    public static final String DATASET_UPDATE_TEMPLATE_COMMENT = "# All columns except \"code\" can be removed from the file.\n# If a column is removed from the file or a cell in a column is left empty the corresponding values of updated data set will be preserved.\n# To delete a value/connection from openBIS one needs to put \"--DELETE--\"  or \\\"__DELETE__\\\" into the corresponding cell\n# (in particular, a data set can become detached from an experiment, sample, container or all parents this way).\n# Basically the \"code\" column should contain a data set code, e.g. 20100823231225012-79089,\n# The \"container\" column (if not removed) should contain a data set code for the new container of the updated data set, e.g. 20100823231225012-83462\n# The \"parents\" column (if not removed) should contain comma separated list of data set codes, e.g. 20100823231225012-93247,20100823231225012-23877\n# The \"experiment\" column (if not removed) should contain an experiment identifier, e.g. /SPACE/PROJECT/EXP_1\n# The \"sample\" column (if not removed) should contain a sample identifier, e.g. /SPACE/SAMPLE_1\n# The \"file_format\" column (if not removed) should contain a file format code, e.g. XML\n";
    private DataSetBatchUpdateDetails batchUpdateDetails;

    public UpdatedDataSet(NewDataSet newDataSet, DataSetBatchUpdateDetails batchUpdateDetails) {
        this.setCode(newDataSet.getCode());
        this.setContainerIdentifierOrNull(newDataSet.getContainerIdentifierOrNull());
        this.setExperimentIdentifier(newDataSet.getExperimentIdentifier());
        this.setFileFormatOrNull(newDataSet.getFileFormatOrNull());
        this.setParentsIdentifiersOrNull(newDataSet.getParentsIdentifiersOrNull());
        this.setProperties(newDataSet.getProperties());
        this.setSampleIdentifierOrNull(newDataSet.getSampleIdentifierOrNull());
        this.batchUpdateDetails = batchUpdateDetails;
    }

    public DataSetBatchUpdateDetails getBatchUpdateDetails() {
        return this.batchUpdateDetails;
    }

    public void setBatchUpdateDetails(DataSetBatchUpdateDetails batchUpdateDetails) {
        this.batchUpdateDetails = batchUpdateDetails;
    }
}

