/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import java.io.File;

public final class StoreItem {
    public static final StoreItem[] EMPTY_ARRAY = new StoreItem[0];
    private final String name;

    public StoreItem(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static final File asFile(File parentDirectory, StoreItem item) {
        assert (item != null) : "Unspecified item";
        assert (parentDirectory != null) : "Unspecified parent directory";
        return new File(parentDirectory, item.getName());
    }

    public static final StoreItem[] asItems(File[] files) {
        assert (files != null) : "Unspecified files";
        int len = files.length;
        StoreItem[] items = new StoreItem[len];
        int i = 0;
        while (i < len) {
            items[i] = StoreItem.asItem(files[i]);
            ++i;
        }
        return items;
    }

    public static final StoreItem asItem(File file) {
        assert (file != null) : "Unspecified file";
        return new StoreItem(file.getName());
    }

    public final String toString() {
        return this.name;
    }

    public final boolean equals(Object obj) {
        return obj != null && obj instanceof StoreItem && this.name.equals(((StoreItem)obj).name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }
}

