/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.maintenance;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class MaintenanceTaskParameters {
    public static final String CLASS_KEY = "class";
    public static final String INTERVAL_KEY = "interval";
    static final String TIME_FORMAT = "HH:mm";
    static final int ONE_DAY_IN_SEC = 86400;
    static final String START_KEY = "start";
    static final String ONE_TIME_EXECUTION_KEY = "execute-only-once";
    private final String pluginName;
    private final long interval;
    private final String className;
    private final Properties properties;
    private final Date startDate;
    private final boolean executeOnlyOnce;

    public MaintenanceTaskParameters(Properties properties, String pluginName) {
        this.properties = properties;
        this.pluginName = pluginName;
        this.interval = PropertyUtils.getLong(properties, INTERVAL_KEY, 86400L);
        this.className = PropertyUtils.getMandatoryProperty(properties, CLASS_KEY);
        this.startDate = MaintenanceTaskParameters.extractStartDate(PropertyUtils.getProperty(properties, START_KEY));
        this.executeOnlyOnce = PropertyUtils.getBoolean(properties, ONE_TIME_EXECUTION_KEY, false);
    }

    private static Date extractStartDate(String timeOrNull) {
        try {
            if (StringUtils.isBlank((String)timeOrNull)) {
                return GregorianCalendar.getInstance().getTime();
            }
            SimpleDateFormat format = new SimpleDateFormat(TIME_FORMAT);
            Date parsedDate = format.parse(timeOrNull);
            Calendar rightHourAndMinutes1970 = GregorianCalendar.getInstance();
            rightHourAndMinutes1970.setTime(parsedDate);
            Calendar result = GregorianCalendar.getInstance();
            result.set(11, rightHourAndMinutes1970.get(11));
            result.set(12, rightHourAndMinutes1970.get(12));
            Calendar now = GregorianCalendar.getInstance();
            if (now.after(result)) {
                result.add(5, 1);
            }
            return result.getTime();
        }
        catch (ParseException parseException) {
            throw new ConfigurationFailureException(String.format("Start date <%s> does not match the required format <%s>", timeOrNull, TIME_FORMAT));
        }
    }

    public boolean isExecuteOnlyOnce() {
        return this.executeOnlyOnce;
    }

    public long getIntervalSeconds() {
        return this.interval;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Date getStartDate() {
        return this.startDate;
    }
}

