/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.namedthread.NamedCallable;
import ch.systemsx.cisd.base.namedthread.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.process.IProcessHandler;
import ch.systemsx.cisd.common.process.IProcessIOHandler;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProcessExecutor {
    private static final long SHORT_TIMEOUT = 100L;
    private static final double OUTPUT_READING_TIMEOUT_FRACTION = 0.1;
    private static final long PAUSE_MILLIS = 10L;
    private static final ExecutorService executor = new NamingThreadPoolExecutor("osproc").corePoolSize(10).daemonize();
    private static final AtomicInteger processCounter = new AtomicInteger();
    private final Logger operationLog;
    private final Logger machineLog;
    private final List<String> commandLine;
    private final long millisToWaitForCompletion;
    private final long millisToWaitForIOCompletion;
    private final ProcessIOStrategy processIOStrategy;
    private final ProcessOutput processOutput;
    private final IProcessIOHandler processIOHandlerOrNull;
    private final int processNumber = processCounter.getAndIncrement();
    private final String callingThreadName = Thread.currentThread().getName();
    private final AtomicReference<ProcessRecord> processWrapper;

    private static final String getCommand(List<String> commandLine) {
        return StringUtils.join(commandLine, (char)' ');
    }

    private final int getExitValue(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return -1;
        }
    }

    private final void readProcessOutput(ProcessRecord processRecord, byte[] buffer) {
        this.readProcessOutput(processRecord, buffer, -1L);
    }

    private final void readProcessOutput(ProcessRecord processRecord, byte[] buffer, long maxBytes) {
        assert (processRecord != null);
        assert (this.machineLog != null);
        Process process = processRecord.getProcess();
        List<String> errorOutput = this.processOutput.getErrorProcessOutput();
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        if (this.processIOStrategy.isBinaryOutput()) {
            try {
                ProcessExecutionHelper.readBytesIfAvailable(process.getInputStream(), this.processOutput.getBinaryProcessOutput(), buffer, maxBytes, this.processIOStrategy.isDiscardStandardOutput());
            }
            catch (IOException e) {
                this.machineLog.warn((Object)String.format("IOException when reading stdout, msg='%s'.", e.getMessage()));
            }
            this.readProcessOutputLines(errorOutput, errorReader, this.processIOStrategy.isDiscardStandardError());
        } else {
            List<String> stdoutLines = this.processOutput.getTextProcessOutput();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            this.readProcessOutputLines(stdoutLines, reader, this.processIOStrategy.isDiscardStandardOutput());
            this.readProcessOutputLines(errorOutput, errorReader, this.processIOStrategy.isDiscardStandardError());
        }
    }

    private final void readProcessOutputLines(List<String> stdoutLines, BufferedReader reader, boolean discard) {
        assert (stdoutLines != null);
        assert (reader != null);
        assert (this.machineLog != null);
        try {
            ProcessExecutionHelper.readTextIfAvailable(reader, stdoutLines, discard);
        }
        catch (IOException e) {
            this.machineLog.warn((Object)String.format("IOException when reading stdout/stderr, msg='%s'.", e.getMessage()));
        }
    }

    ProcessExecutor(List<String> commandLine, long millisToWaitForCompletion, ProcessIOStrategy ioStrategy, Logger operationLog, Logger machineLog) {
        this.operationLog = operationLog;
        this.machineLog = machineLog;
        this.millisToWaitForCompletion = millisToWaitForCompletion == 0L ? -1L : millisToWaitForCompletion;
        this.millisToWaitForIOCompletion = Math.round(millisToWaitForCompletion == -1L ? -1.0 : (double)this.millisToWaitForCompletion * 0.1);
        this.processIOStrategy = ioStrategy;
        this.commandLine = Collections.unmodifiableList(commandLine);
        this.processOutput = new ProcessOutput();
        this.processWrapper = new AtomicReference();
        this.processIOHandlerOrNull = !ioStrategy.isUseNoIOHandler() && ioStrategy.tryGetCustomIOHandler() == null ? (this.processIOStrategy.isBinaryOutput() ? new BinaryProcessIOHandler() : new TextProcessIOHandler()) : ioStrategy.tryGetCustomIOHandler();
    }

    final IProcessHandler runUnblocking() {
        final Future<ProcessResult> runnerFuture = this.launchProcessExecutor();
        return new IProcessHandler(){
            private final boolean stopOnInterruption = true;

            public boolean terminate() {
                ExecutionResult executionResult = ProcessExecutor.this.killProcess(ExecutionStatus.TIMED_OUT, true);
                return executionResult.tryGetResult() != null;
            }

            public ProcessResult getResult() {
                return ProcessExecutor.this.getProcessResult(true, runnerFuture, ProcessExecutor.this.millisToWaitForCompletion);
            }

            public ProcessResult getResult(long millisToWaitForCompletion) {
                return ProcessExecutor.this.getProcessResult(true, runnerFuture, millisToWaitForCompletion);
            }
        };
    }

    private ExecutionResult<?> getAndLogProcessIOResult(ProcessRecord record, long timeout) {
        if (this.processIOStrategy.isUseNoIOHandler()) {
            return ExecutionResult.create(null);
        }
        if (record.tryGetProcessIOFuture() == null) {
            return ExecutionResult.createExceptional(new Error("Missing IO result."));
        }
        record.isProcessRunning().set(false);
        ExecutionResult<?> processIOResult = ConcurrencyUtilities.getResult(record.tryGetProcessIOFuture(), timeout);
        this.logProcessIOFailures(processIOResult);
        return processIOResult;
    }

    private void logProcessIOFailures(ExecutionResult<?> processIOResult) {
        switch (processIOResult.getStatus()) {
            case COMPLETE: {
                break;
            }
            case EXCEPTION: {
                Throwable th = processIOResult.tryGetException();
                Throwable cause = th == null ? new RuntimeException("Unknown exception.") : (th instanceof Error ? (Error)th : CheckedExceptionTunnel.unwrapIfNecessary((Exception)((Exception)th)));
                this.machineLog.warn((Object)String.format("Exception when doing process I/O, type='%s', msg='%s'.", cause.getClass().getSimpleName(), cause.getMessage()));
                break;
            }
            case INTERRUPTED: {
                this.machineLog.warn((Object)"Interrupted when doing process I/O.");
                break;
            }
            case TIMED_OUT: {
                this.machineLog.warn((Object)"Timeout when doing process I/O.");
            }
        }
    }

    final ProcessResult run(boolean stopOnInterrupt) {
        Future<ProcessResult> runnerFuture = this.launchProcessExecutor();
        return this.getProcessResult(stopOnInterrupt, runnerFuture, this.millisToWaitForCompletion);
    }

    private ProcessResult getProcessResult(boolean stopOnInterrupt, Future<ProcessResult> runnerFuture, long millisToWaitForCompletionOverride) {
        ExecutionResult<ProcessResult> executionResult = ProcessExecutor.getExecutionResult(runnerFuture, millisToWaitForCompletionOverride);
        if (executionResult.getStatus() != ExecutionStatus.COMPLETE && (executionResult = this.killProcess(executionResult.getStatus(), stopOnInterrupt)).tryGetResult() == null) {
            executionResult = ConcurrencyUtilities.getResult(runnerFuture, 0L);
        }
        ProcessExecutor.checkStop(executionResult.getStatus(), stopOnInterrupt);
        ProcessResult result = executionResult.tryGetResult();
        if (result != null) {
            return result;
        }
        ExecutionStatus status = executionResult.getStatus();
        if (status == ExecutionStatus.COMPLETE) {
            status = ExecutionStatus.INTERRUPTED;
        }
        if (this.processIOStrategy.isBinaryOutput()) {
            return new ProcessResult(this.commandLine, this.processNumber, status, (ExecutionResult<?>)executionResult, ProcessExecutor.tryGetStartupFailureMessage(executionResult.tryGetException()), -1, null, null, this.operationLog, this.machineLog);
        }
        return new ProcessResult(this.commandLine, this.processNumber, status, (ExecutionResult<?>)executionResult, ProcessExecutor.tryGetStartupFailureMessage(executionResult.tryGetException()), -1, null, null, this.operationLog, this.machineLog);
    }

    private ExecutionResult<ProcessResult> killProcess(ExecutionStatus executionStatus, boolean stopOnInterrupt) {
        Future killerFuture = executor.submit(new ProcessKiller(executionStatus));
        ProcessExecutor.checkStop(executionStatus, stopOnInterrupt);
        return ConcurrencyUtilities.getResult(killerFuture, 100L);
    }

    private static ExecutionResult<ProcessResult> getExecutionResult(Future<ProcessResult> runnerFuture, long millisToWaitForCompletion) {
        return ConcurrencyUtilities.getResult(runnerFuture, millisToWaitForCompletion, false, null);
    }

    private boolean hasIOHandler() {
        return this.processIOHandlerOrNull != null;
    }

    private Future<ProcessResult> launchProcessExecutor() {
        if (this.hasIOHandler()) {
            return executor.submit(new ProcessRunnerWithIOHandler());
        }
        return executor.submit(new ProcessRunnerIOInSameThread());
    }

    private static final void checkStop(ExecutionStatus executionStatus, boolean stopOnInterrupt) throws InterruptedExceptionUnchecked {
        if (stopOnInterrupt && ExecutionStatus.INTERRUPTED.equals((Object)executionStatus)) {
            throw new InterruptedExceptionUnchecked();
        }
    }

    private static final String tryGetStartupFailureMessage(Throwable throwableOrNull) {
        if (throwableOrNull != null && throwableOrNull instanceof IOException) {
            return throwableOrNull.getMessage();
        }
        return null;
    }

    private class BinaryProcessIOHandler
    implements IProcessIOHandler {
        private BinaryProcessIOHandler() {
        }

        public void handle(AtomicBoolean processRunning, OutputStream stdin, InputStream stdout, InputStream stderr) throws IOException {
            BufferedReader bufStderr = new BufferedReader(new InputStreamReader(stderr));
            byte[] buf = new byte[4096];
            while (processRunning.get()) {
                ProcessExecutionHelper.readBytesIfAvailable(stdout, ProcessExecutor.this.processOutput.processBinaryOutput, buf, -1L, ProcessExecutor.this.processIOStrategy.isDiscardStandardOutput());
                ProcessExecutionHelper.readTextIfAvailable(bufStderr, ProcessExecutor.this.processOutput.processErrorOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardError());
            }
            ProcessExecutionHelper.readBytesIfAvailable(stdout, ProcessExecutor.this.processOutput.processBinaryOutput, buf, -1L, ProcessExecutor.this.processIOStrategy.isDiscardStandardOutput());
            ProcessExecutionHelper.readTextIfAvailable(bufStderr, ProcessExecutor.this.processOutput.processErrorOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardError());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcessKiller
    implements NamedCallable<ProcessResult> {
        private final ExecutionStatus status;

        private ProcessKiller(ExecutionStatus status) {
            this.status = status;
        }

        public final ProcessResult call() {
            ProcessRecord processRecord = ProcessExecutor.this.processWrapper.getAndSet(null);
            if (processRecord != null) {
                ExecutionResult processIOResultOrNull = ProcessExecutor.this.getAndLogProcessIOResult(processRecord, ProcessExecutor.this.millisToWaitForIOCompletion);
                Process process = processRecord.getProcess();
                process.destroy();
                if (ProcessExecutor.this.machineLog.isInfoEnabled()) {
                    ProcessExecutor.this.machineLog.info((Object)String.format("Killed '%s'.", ProcessExecutor.getCommand(ProcessExecutor.this.commandLine)));
                }
                int exitValue = ProcessExecutor.this.getExitValue(processRecord.getProcess());
                if (ProcessExecutor.this.processIOStrategy.isBinaryOutput()) {
                    return new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, this.status, processIOResultOrNull, "", exitValue, ProcessExecutor.this.processOutput.getBinaryProcessOutput().toByteArray(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
                }
                return new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, this.status, processIOResultOrNull, "", exitValue, ProcessExecutor.this.processOutput.getTextProcessOutput(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
            }
            return null;
        }

        public final String getCallableName() {
            return String.valueOf(ProcessExecutor.this.callingThreadName) + "::kill-P" + ProcessExecutor.this.processNumber + "-{" + ProcessExecutionHelper.getCommandName(ProcessExecutor.this.commandLine) + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcessOutput {
        private final List<String> processTextOutput;
        private final List<String> processErrorOutput;
        private final ByteArrayOutputStream processBinaryOutput;

        ProcessOutput() {
            if (ProcessExecutor.this.processIOStrategy.isBinaryOutput()) {
                this.processTextOutput = null;
                this.processErrorOutput = new ArrayList<String>();
                this.processBinaryOutput = new ByteArrayOutputStream();
            } else {
                this.processTextOutput = new ArrayList<String>();
                this.processErrorOutput = new ArrayList<String>();
                this.processBinaryOutput = null;
            }
        }

        List<String> getTextProcessOutput() {
            return this.processTextOutput;
        }

        ByteArrayOutputStream getBinaryProcessOutput() {
            return this.processBinaryOutput;
        }

        List<String> getErrorProcessOutput() {
            return this.processErrorOutput;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ProcessRecord {
        private final Process process;
        private final Future<?> processIOFutureOrNull;
        private final AtomicBoolean processRunning;

        ProcessRecord(Process process, Future<?> processIOFutureOrNull, AtomicBoolean processRunning) {
            this.process = process;
            this.processRunning = processRunning;
            this.processIOFutureOrNull = processIOFutureOrNull;
        }

        Future<?> tryGetProcessIOFuture() {
            return this.processIOFutureOrNull;
        }

        AtomicBoolean isProcessRunning() {
            return this.processRunning;
        }

        Process getProcess() {
            return this.process;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessRunnerIOInSameThread
    implements NamedCallable<ProcessResult> {
        private ProcessRunnerIOInSameThread() {
        }

        private final Process launch() throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(ProcessExecutor.this.commandLine);
            if (ProcessExecutor.this.processIOStrategy.isMergeStderr()) {
                processBuilder.redirectErrorStream(true);
            }
            if (ProcessExecutor.this.operationLog.isDebugEnabled()) {
                ProcessExecutor.this.operationLog.debug((Object)("Running command: " + ProcessExecutor.getCommand(ProcessExecutor.this.commandLine) + " (I/O in same thread)"));
            }
            return processBuilder.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final ProcessResult call() throws Exception {
            try {
                Process process = this.launch();
                try {
                    int exitValue = -1;
                    ProcessRecord processRecord = new ProcessRecord(process, null, null);
                    ProcessExecutor.this.processWrapper.set(processRecord);
                    byte[] buffer = new byte[4096];
                    while (true) {
                        if (exitValue != -1) {
                            ProcessExecutor.this.readProcessOutput(processRecord, buffer);
                            ProcessExecutor.this.processWrapper.set(null);
                            if (!ProcessExecutor.this.processIOStrategy.isBinaryOutput()) break;
                            ProcessResult processResult = new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, ExecutionStatus.COMPLETE, ExecutionResult.create(null), "", exitValue, ProcessExecutor.this.processOutput.getBinaryProcessOutput().toByteArray(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
                            return processResult;
                        }
                        ProcessExecutor.this.readProcessOutput(processRecord, buffer);
                        exitValue = ProcessExecutor.this.getExitValue(process);
                        if (exitValue != -1) continue;
                        ConcurrencyUtilities.sleep(10L);
                    }
                    ProcessResult processResult = new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, ExecutionStatus.COMPLETE, ExecutionResult.create(null), "", exitValue, ProcessExecutor.this.processOutput.getTextProcessOutput(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
                    return processResult;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)process.getErrorStream());
                    IOUtils.closeQuietly((InputStream)process.getInputStream());
                    IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                }
            }
            catch (Exception ex) {
                ProcessExecutor.this.machineLog.error((Object)String.format("Exception when launching: [%s, %s]", ex.getClass().getSimpleName(), StringUtils.defaultIfEmpty((String)ex.getMessage(), (String)"NO MESSAGE")));
                throw ex;
            }
        }

        public String getCallableName() {
            return String.valueOf(ProcessExecutor.this.callingThreadName) + "::run-P" + ProcessExecutor.this.processNumber + "-{" + ProcessExecutionHelper.getCommandName(ProcessExecutor.this.commandLine) + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessRunnerWithIOHandler
    implements NamedCallable<ProcessResult> {
        private ProcessRunnerWithIOHandler() {
        }

        private final Process launch() throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(ProcessExecutor.this.commandLine);
            if (ProcessExecutor.this.processIOStrategy.isMergeStderr()) {
                processBuilder.redirectErrorStream(true);
            }
            if (ProcessExecutor.this.operationLog.isDebugEnabled()) {
                ProcessExecutor.this.operationLog.debug((Object)("Running command: " + ProcessExecutor.getCommand(ProcessExecutor.this.commandLine) + " (I/O in separate thread)"));
            }
            return processBuilder.start();
        }

        public final ProcessResult call() throws Exception {
            try {
                final Process process = this.launch();
                int exitValue = -1;
                final AtomicBoolean processRunning = new AtomicBoolean(true);
                Future<?> ioFuture = executor.submit(new Runnable(){

                    public void run() {
                        try {
                            try {
                                ProcessExecutor.this.processIOHandlerOrNull.handle(processRunning, process.getOutputStream(), process.getInputStream(), process.getErrorStream());
                            }
                            catch (IOException ex) {
                                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                            }
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)process.getErrorStream());
                            IOUtils.closeQuietly((InputStream)process.getInputStream());
                            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                        }
                    }
                });
                ProcessRecord processRecord = new ProcessRecord(process, ioFuture, processRunning);
                ProcessExecutor.this.processWrapper.set(processRecord);
                exitValue = process.waitFor();
                ExecutionResult processIOResult = ProcessExecutor.this.getAndLogProcessIOResult(processRecord, ProcessExecutor.this.millisToWaitForIOCompletion);
                ProcessExecutor.this.processWrapper.set(null);
                if (ProcessExecutor.this.processIOStrategy.isBinaryOutput()) {
                    return new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, ExecutionStatus.COMPLETE, processIOResult, "", exitValue, ProcessExecutor.this.processOutput.getBinaryProcessOutput().toByteArray(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
                }
                return new ProcessResult((List<String>)ProcessExecutor.this.commandLine, ProcessExecutor.this.processNumber, ExecutionStatus.COMPLETE, processIOResult, "", exitValue, ProcessExecutor.this.processOutput.getTextProcessOutput(), ProcessExecutor.this.processOutput.getErrorProcessOutput(), ProcessExecutor.this.operationLog, ProcessExecutor.this.machineLog);
            }
            catch (Exception ex) {
                ProcessExecutor.this.machineLog.error((Object)String.format("Exception when launching: [%s, %s]", ex.getClass().getSimpleName(), StringUtils.defaultIfEmpty((String)ex.getMessage(), (String)"NO MESSAGE")));
                throw ex;
            }
        }

        public String getCallableName() {
            return String.valueOf(ProcessExecutor.this.callingThreadName) + "::run-P" + ProcessExecutor.this.processNumber + "-{" + ProcessExecutionHelper.getCommandName(ProcessExecutor.this.commandLine) + "}";
        }
    }

    private class TextProcessIOHandler
    implements IProcessIOHandler {
        private TextProcessIOHandler() {
        }

        public void handle(AtomicBoolean processRunning, OutputStream stdin, InputStream stdout, InputStream stderr) throws IOException {
            BufferedReader bufStdout = new BufferedReader(new InputStreamReader(stdout));
            BufferedReader bufStderr = new BufferedReader(new InputStreamReader(stderr));
            while (processRunning.get()) {
                ProcessExecutionHelper.readTextIfAvailable(bufStdout, ProcessExecutor.this.processOutput.processTextOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardOutput());
                ProcessExecutionHelper.readTextIfAvailable(bufStderr, ProcessExecutor.this.processOutput.processErrorOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardError());
            }
            ProcessExecutionHelper.readTextIfAvailable(bufStdout, ProcessExecutor.this.processOutput.processTextOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardOutput());
            ProcessExecutionHelper.readTextIfAvailable(bufStderr, ProcessExecutor.this.processOutput.processErrorOutput, ProcessExecutor.this.processIOStrategy.isDiscardStandardError());
        }
    }
}

