/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.utilities.IChecksumCalculator;
import com.twmacinta.util.MD5;
import com.twmacinta.util.MD5InputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;

public final class MD5ChecksumCalculator
implements IChecksumCalculator {
    public String calculateChecksum(InputStream inputStream) throws IOException {
        return MD5ChecksumCalculator.doCalculation(inputStream, 4096);
    }

    private static String calculate(InputStream inputStream, int bufferSize) {
        try {
            return MD5ChecksumCalculator.doCalculation(inputStream, bufferSize);
        }
        catch (IOException ex) {
            throw new IllegalStateException("This should not happen: " + ex.getMessage());
        }
    }

    static String doCalculation(InputStream inputStream, int bufferSize) throws IOException {
        byte[] buf = new byte[bufferSize];
        MD5InputStream in = new MD5InputStream(inputStream);
        while (in.read(buf) != -1) {
        }
        return MD5.asHex((byte[])in.hash());
    }

    public static String calculate(byte[] bytes) {
        assert (bytes != null) : "Unspecified byte array.";
        return MD5ChecksumCalculator.calculate(new ByteArrayInputStream(bytes), bytes.length);
    }

    public static String calculate(InputStream stream) throws IOException {
        MD5InputStream md5InputStream = new MD5InputStream(stream);
        IOUtils.copyLarge((InputStream)md5InputStream, (OutputStream)new OutputStream(){

            public void write(int b) throws IOException {
            }
        });
        return MD5.asHex((byte[])md5InputStream.hash());
    }

    public static String calculate(String value) {
        assert (value != null && value.length() > 0) : "Value cannot be blank.";
        final StringReader reader = new StringReader(value);
        InputStream inputStream = new InputStream(){

            public int read() throws IOException {
                return reader.read();
            }
        };
        return MD5ChecksumCalculator.calculate(inputStream, value.length());
    }
}

