/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.cli;

import ch.systemsx.cisd.args4j.CmdLineParser;
import ch.systemsx.cisd.common.cli.ConsoleClientArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.AbstractDssCommand;
import ch.systemsx.cisd.openbis.dss.client.api.cli.GlobalArguments;
import ch.systemsx.cisd.openbis.dss.client.api.cli.ResultCode;
import ch.systemsx.cisd.openbis.dss.client.api.v1.IDssComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractExecutor<A extends GlobalArguments> {
    protected final A arguments;
    private final CmdLineParser parser;
    private final AbstractDssCommand<A> command;

    AbstractExecutor(A arguments, AbstractDssCommand<A> command) {
        this.arguments = arguments;
        this.command = command;
        this.parser = new CmdLineParser(arguments);
    }

    final ResultCode execute(String[] args) {
        this.parser.parseArgument(args);
        if (((ConsoleClientArguments)this.arguments).isHelp()) {
            this.command.printUsage(System.out);
            return ResultCode.OK;
        }
        if (!((ConsoleClientArguments)this.arguments).isComplete()) {
            this.command.printUsage(System.err);
            return ResultCode.INVALID_ARGS;
        }
        IDssComponent component = null;
        try {
            component = this.command.login((GlobalArguments)this.arguments);
            if (component == null) {
                ResultCode resultCode = ResultCode.INVALID_UNAME_PASS;
                return resultCode;
            }
            ResultCode resultCode = this.doExecute(component);
            return resultCode;
        }
        finally {
            if (component != null) {
                component.logout();
            }
        }
    }

    protected abstract ResultCode doExecute(IDssComponent var1);
}

