/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.client.api.gui;

import ch.systemsx.cisd.openbis.dss.client.api.gui.DataSetUploadClientModel;
import ch.systemsx.cisd.openbis.dss.client.api.gui.VocabularyTermsComboBoxPanel;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AddVocabularyTermDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel;
    private JPanel gridPanel;
    private final JTextField codeField = new JTextField();
    private final JTextField labelField = new JTextField();
    private JTextArea descriptionField = new JTextArea();
    private JComboBox vocabularyTermsField = new JComboBox();
    private final Vocabulary vocabulary;
    private final DataSetUploadClientModel clientModel;

    public AddVocabularyTermDialog(JFrame mainWindow, ComboBoxModel comboBoxModel, Vocabulary vocabulary, DataSetUploadClientModel clientModel) {
        super(mainWindow, "Add Ad Hoc vocabulary term", true);
        this.vocabulary = vocabulary;
        this.clientModel = clientModel;
        this.mainPanel = new JPanel(new BorderLayout());
        this.gridPanel = this.createMainPanel(comboBoxModel);
        this.mainPanel.add((Component)this.gridPanel, "Center");
        this.mainPanel.add((Component)this.createButtonsPanel(), "South");
        this.setContentPane(this.mainPanel);
        this.setSize(500, 300);
        Point mwLocation = mainWindow.getLocationOnScreen();
        int x = mwLocation.x + mainWindow.getWidth() / 2 - this.getWidth() / 2;
        int y = mwLocation.y + mainWindow.getHeight() / 2 - this.getHeight() / 2;
        this.setLocation(x > 0 ? x : 0, y > 0 ? y : 0);
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        JButton addButton = new JButton("Add");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddVocabularyTermDialog.this.clientModel.addUnofficialVocabularyTerm(AddVocabularyTermDialog.this.vocabulary, AddVocabularyTermDialog.this.codeField.getText(), AddVocabularyTermDialog.this.labelField.getText().trim(), AddVocabularyTermDialog.this.descriptionField.getText(), AddVocabularyTermDialog.this.extractPreviousTermOrdinal());
                AddVocabularyTermDialog.this.dispose();
            }
        });
        buttonsPanel.add(addButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddVocabularyTermDialog.this.dispose();
            }
        });
        buttonsPanel.add(cancelButton);
        return buttonsPanel;
    }

    private Long extractPreviousTermOrdinal() {
        VocabularyTermsComboBoxPanel.VocabularyTermAdaptor selectedItem = (VocabularyTermsComboBoxPanel.VocabularyTermAdaptor)this.vocabularyTermsField.getSelectedItem();
        return selectedItem != null ? selectedItem.getOrdinal() : 0L;
    }

    private JPanel createMainPanel(ComboBoxModel comboBoxModel) {
        JPanel panel = new JPanel(new GridBagLayout());
        this.codeField.setEnabled(false);
        this.labelField.requestFocus();
        this.labelField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
                this.handleEvent();
            }

            public void keyReleased(KeyEvent arg0) {
                this.handleEvent();
            }

            public void keyTyped(KeyEvent arg0) {
                this.handleEvent();
            }

            private void handleEvent() {
                AddVocabularyTermDialog.this.codeField.setText(CodeNormalizer.normalize(AddVocabularyTermDialog.this.labelField.getText()));
            }
        });
        int i = 0;
        while (i < comboBoxModel.getSize()) {
            this.vocabularyTermsField.addItem(comboBoxModel.getElementAt(i));
            ++i;
        }
        AddVocabularyTermDialog.selectMaxOrdinal(this.vocabularyTermsField);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel("Code:"), c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.codeField, c);
        c.gridy = 1;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel("Label:"), c);
        c.gridy = 1;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.labelField, c);
        c.gridy = 2;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel("Description:"), c);
        c.gridy = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JScrollPane(this.descriptionField), c);
        c.gridy = 3;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)new JLabel("Position after:"), c);
        c.gridy = 3;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)this.vocabularyTermsField, c);
        return panel;
    }

    private static void selectMaxOrdinal(JComboBox comboBox) {
        ComboBoxModel model = comboBox.getModel();
        long maxOrdinal = Long.MIN_VALUE;
        int maxItemIndex = -1;
        int i = 0;
        while (i < model.getSize()) {
            Long ordinal = ((VocabularyTermsComboBoxPanel.VocabularyTermAdaptor)model.getElementAt(i)).getOrdinal();
            if (maxOrdinal < ordinal) {
                maxOrdinal = ordinal;
                maxItemIndex = i;
            }
            ++i;
        }
        if (maxItemIndex > -1) {
            comboBox.setSelectedIndex(maxItemIndex);
        }
    }
}

